/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.couchbase;

import com.couchbase.client.java.Bucket;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.couchbase.CouchbaseHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.couchbase.CouchbaseDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.core.CouchbaseOperations;

@Configuration
@ConditionalOnClass(value={CouchbaseOperations.class, Bucket.class})
@ConditionalOnBean(value={CouchbaseOperations.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={CouchbaseDataAutoConfiguration.class})
public class CouchbaseHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<CouchbaseHealthIndicator, CouchbaseOperations> {
    private final Map<String, CouchbaseOperations> couchbaseOperations;

    public CouchbaseHealthIndicatorAutoConfiguration(Map<String, CouchbaseOperations> couchbaseOperations) {
        this.couchbaseOperations = couchbaseOperations;
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator"})
    public HealthIndicator couchbaseHealthIndicator() {
        return this.createHealthIndicator(this.couchbaseOperations);
    }
}

