/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.mappings;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.actuate.web.mappings.reactive.DispatcherHandlersMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletsMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.FiltersMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.ServletsMappingDescriptionProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.servlet.DispatcherServlet;

@ManagementContextConfiguration
public class MappingsEndpointAutoConfiguration {
    @Bean
    @ConditionalOnEnabledEndpoint
    public MappingsEndpoint mappingsEndpoint(ApplicationContext applicationContext, ObjectProvider<Collection<MappingDescriptionProvider>> descriptionProviders) {
        return new MappingsEndpoint((Collection)descriptionProviders.getIfAvailable(Collections::emptyList), applicationContext);
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnClass(value={DispatcherHandler.class})
    @ConditionalOnBean(value={DispatcherHandler.class})
    static class ReactiveWebConfiguration {
        ReactiveWebConfiguration() {
        }

        @Bean
        public DispatcherHandlersMappingDescriptionProvider dispatcherHandlerMappingDescriptionProvider(ApplicationContext applicationContext) {
            return new DispatcherHandlersMappingDescriptionProvider();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletWebConfiguration {
        ServletWebConfiguration() {
        }

        @Bean
        ServletsMappingDescriptionProvider servletMappingDescriptionProvider() {
            return new ServletsMappingDescriptionProvider();
        }

        @Bean
        FiltersMappingDescriptionProvider filterMappingDescriptionProvider() {
            return new FiltersMappingDescriptionProvider();
        }

        @Configuration
        @ConditionalOnClass(value={DispatcherServlet.class})
        @ConditionalOnBean(value={DispatcherServlet.class})
        static class SpringMvcConfiguration {
            SpringMvcConfiguration() {
            }

            @Bean
            DispatcherServletsMappingDescriptionProvider dispatcherServletMappingDescriptionProvider() {
                return new DispatcherServletsMappingDescriptionProvider();
            }
        }
    }
}

