/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.convert.DurationStyle;

public final class ServiceLevelAgreementBoundary {
    private final Object value;

    ServiceLevelAgreementBoundary(long value) {
        this.value = value;
    }

    ServiceLevelAgreementBoundary(Duration value) {
        this.value = value;
    }

    public Long getValue(Meter.Type meterType) {
        if (meterType == Meter.Type.DISTRIBUTION_SUMMARY) {
            return this.getDistributionSummaryValue();
        }
        if (meterType == Meter.Type.TIMER) {
            return this.getTimerValue();
        }
        return null;
    }

    private Long getDistributionSummaryValue() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        return null;
    }

    private Long getTimerValue() {
        if (this.value instanceof Long) {
            return TimeUnit.MILLISECONDS.toNanos((Long)this.value);
        }
        if (this.value instanceof Duration) {
            return ((Duration)this.value).toNanos();
        }
        return null;
    }

    public static ServiceLevelAgreementBoundary valueOf(String value) {
        if (ServiceLevelAgreementBoundary.isNumber(value)) {
            return new ServiceLevelAgreementBoundary(Long.parseLong(value));
        }
        return new ServiceLevelAgreementBoundary(DurationStyle.detectAndParse((String)value));
    }

    public static ServiceLevelAgreementBoundary valueOf(long value) {
        return new ServiceLevelAgreementBoundary(value);
    }

    private static boolean isNumber(String value) {
        return value.chars().allMatch(Character::isDigit);
    }
}

