/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import io.searchbox.client.JestClient;
import java.time.Duration;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticsearchHealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchHealthIndicator;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchJestHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.autoconfigure.elasticsearch.jest.JestAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={ElasticsearchAutoConfiguration.class, JestAutoConfiguration.class})
public class ElasticsearchHealthIndicatorAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={JestClient.class})
    @ConditionalOnBean(value={JestClient.class})
    static class ElasticsearchJestHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<ElasticsearchJestHealthIndicator, JestClient> {
        private final Map<String, JestClient> clients;

        ElasticsearchJestHealthIndicatorConfiguration(Map<String, JestClient> clients) {
            this.clients = clients;
        }

        @Bean
        @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
        public HealthIndicator elasticsearchHealthIndicator() {
            return this.createHealthIndicator(this.clients);
        }

        @Override
        protected ElasticsearchJestHealthIndicator createHealthIndicator(JestClient client) {
            return new ElasticsearchJestHealthIndicator(client);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Client.class})
    @ConditionalOnBean(value={Client.class})
    @EnableConfigurationProperties(value={ElasticsearchHealthIndicatorProperties.class})
    static class ElasticsearchClientHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<ElasticsearchHealthIndicator, Client> {
        private final Map<String, Client> clients;
        private final ElasticsearchHealthIndicatorProperties properties;

        ElasticsearchClientHealthIndicatorConfiguration(Map<String, Client> clients, ElasticsearchHealthIndicatorProperties properties) {
            this.clients = clients;
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
        public HealthIndicator elasticsearchHealthIndicator() {
            return this.createHealthIndicator(this.clients);
        }

        @Override
        protected ElasticsearchHealthIndicator createHealthIndicator(Client client) {
            Duration responseTimeout = this.properties.getResponseTimeout();
            return new ElasticsearchHealthIndicator(client, responseTimeout == null ? 100L : responseTimeout.toMillis(), this.properties.getIndices());
        }
    }
}

