/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openqa.selenium.Platform;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.server.ClassPathResource;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class ResourceExtractor {
    private static Logger log = Logger.getLogger(ResourceExtractor.class.getName());

    public static File extractResourcePath(Class cl, String resourcePath, File dest) throws IOException {
        boolean alwaysExtract = true;
        URL url = Resources.getResource((Class)cl, (String)resourcePath);
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            File jarFile = ResourceExtractor.getJarFileFromUrl(url);
            ResourceExtractor.extractResourcePathFromJar(cl, jarFile, resourcePath, dest);
        } else {
            try {
                File resourceFile = new File(new URI(url.toExternalForm()));
                if (!alwaysExtract) {
                    return resourceFile;
                }
                if (resourceFile.isDirectory()) {
                    LauncherUtils.copyDirectory(resourceFile, dest);
                } else {
                    FileHandler.copy((File)resourceFile, (File)dest);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Couldn't convert URL to File:" + url, e);
            }
        }
        return dest;
    }

    private static void extractResourcePathFromJar(Class cl, File jarFile, String resourcePath, File dest) throws IOException {
        ZipFile z = new ZipFile(jarFile, 1);
        String zipStyleResourcePath = resourcePath.substring(1) + "/";
        ZipEntry ze = z.getEntry(zipStyleResourcePath);
        log.fine("Extracting " + resourcePath + " to " + dest.getAbsolutePath());
        if (ze != null) {
            Enumeration<? extends ZipEntry> entries = z.entries();
            while (entries.hasMoreElements()) {
                ze = entries.nextElement();
                if (!ze.getName().startsWith(zipStyleResourcePath)) continue;
                String relativePath = ze.getName().substring(zipStyleResourcePath.length());
                File destFile = new File(dest, relativePath);
                if (ze.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                ResourceExtractor.copyStream(z.getInputStream(ze), fos);
            }
        } else {
            FileOutputStream fos = new FileOutputStream(dest);
            ResourceExtractor.copyStream(ClassPathResource.getSeleniumResourceAsStream(resourcePath), fos);
        }
    }

    public static void traceWith(Logger log) {
        ResourceExtractor.log = log;
    }

    private static File getJarFileFromUrl(URL url) {
        System.out.println(url);
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("This is not a Jar URL:" + url.toString());
        }
        String resourceFilePath = url.getFile();
        int index = resourceFilePath.lastIndexOf("!");
        if (index == -1) {
            throw new RuntimeException("Bug! " + url.toExternalForm() + " does not have a '!'");
        }
        String jarFileURI = resourceFilePath.substring(0, index).replace(" ", "%20");
        if (Platform.getCurrent().is(Platform.WINDOWS) && jarFileURI.startsWith("file://")) {
            jarFileURI = jarFileURI.replaceFirst("file://", "file:////");
        }
        try {
            File jarFile = new File(new URI(jarFileURI));
            return jarFile;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug! URI failed to parse: " + jarFileURI, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            out.close();
            in.close();
        }
    }
}

