/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.io.File;

public class LoggingOptions {
    private boolean dontTouchLogging;
    private boolean captureLogsOnQuit;
    private String logOutFileName = LoggingOptions.getDefaultLogOutFile();

    public boolean dontTouchLogging() {
        return this.dontTouchLogging;
    }

    public void setDontTouchLogging(boolean newValue) {
        this.dontTouchLogging = newValue;
    }

    public int shortTermMemoryLoggerCapacity() {
        return 30;
    }

    public boolean isCaptureOfLogsOnQuitEnabled() {
        return this.captureLogsOnQuit;
    }

    public void setCaptureLogsOnQuit(boolean captureLogs) {
        this.captureLogsOnQuit = captureLogs;
    }

    public File getLogOutFile() {
        return null == this.logOutFileName ? null : new File(this.logOutFileName);
    }

    public void setLogOutFileName(String newLogOutFileName) {
        this.logOutFileName = newLogOutFileName;
    }

    public String getLogOutFileName() {
        return this.logOutFileName;
    }

    public void setLogOutFile(File newLogOutFile) {
        this.logOutFileName = null == newLogOutFile ? null : newLogOutFile.getAbsolutePath();
    }

    public static String getDefaultLogOutFile() {
        String logOutFileProperty = System.getProperty("selenium.LOGGER");
        if (null == logOutFileProperty) {
            return null;
        }
        return new File(logOutFileProperty).getAbsolutePath();
    }
}

