/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.browserlaunchers.Sleeper;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.CombinedFirefoxLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;

public class FirefoxCustomProfileLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(FirefoxCustomProfileLauncher.class.getName());
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private CommandLine process;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;
    private File customProfileDir = null;

    public FirefoxCustomProfileLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) throws InvalidBrowserExecutableException {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("firefoxproxy", browserLaunchLocation, (BrowserLocator)new CombinedFirefoxLocator()));
        if (this.browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
    }

    public FirefoxCustomProfileLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        this.browserConfigurationOptions = Proxies.setProxyEverything((Capabilities)this.browserConfigurationOptions, (boolean)false);
        this.browserConfigurationOptions = Proxies.setOnlyProxySeleniumTraffic((Capabilities)this.browserConfigurationOptions, (boolean)true);
        this.init();
        this.browserInstallation = browserInstallation;
    }

    protected void init() {
    }

    @Override
    protected void launch(String url) {
        try {
            log.fine("customProfileDir = " + this.customProfileDir());
            this.makeCustomProfile(this.customProfileDir());
            String chromeURL = "chrome://killff/content/kill.html";
            CommandLine command = this.prepareCommand(this.browserInstallation.launcherFilePath(), "-profile", this.customProfileDir().getAbsolutePath(), "-chrome", chromeURL);
            log.info("Preparing Firefox profile...");
            command.execute();
            this.waitForFullProfileToBeCreated(20000L);
            log.info("Launching Firefox...");
            this.process = this.prepareCommand(this.browserInstallation.launcherFilePath(), "-profile", this.customProfileDir().getAbsolutePath(), url);
            this.process.executeAsync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandLine prepareCommand(String ... commands) {
        CommandLine command = new CommandLine(commands);
        command.setDynamicLibraryPath(this.browserInstallation.libraryPath());
        command.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
        return command;
    }

    private void makeCustomProfile(File customProfileDirectory) throws IOException {
        File firefoxProfileTemplate = BrowserOptions.getFile(this.browserConfigurationOptions, "firefoxProfileTemplate");
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory((File)firefoxProfileTemplate, (File)this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), "/customProfileDirCUSTFF", this.customProfileDir);
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copySingleFileWithOverwrite((File)new File(firefoxProfileTemplate, "cert8.db"), (File)new File(this.customProfileDir, "cert8.db"), (boolean)true);
        }
        LauncherUtils.generatePacAndPrefJs((File)customProfileDirectory, (int)this.getPort(), null, (boolean)this.changeMaxConnections, (long)this.getTimeout(), (Capabilities)this.browserConfigurationOptions);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process != null) {
            this.killFirefoxProcess();
        }
        if (this.customProfileDir != null) {
            this.removeCustomProfileDir();
        }
        this.closed = true;
    }

    protected void removeCustomProfileDir() throws RuntimeException {
        LauncherUtils.deleteTryTryAgain((File)this.customProfileDir, (int)6);
    }

    protected void killFirefoxProcess() {
        log.info("Killing Firefox...");
        int exitValue = this.process.destroy();
        if (exitValue == 0) {
            log.warning("Firefox seems to have ended on its own (did we kill the real browser???)");
        }
    }

    protected void setCustomProfileDir(File value) {
        this.customProfileDir = value;
    }

    protected void setCommandLine(CommandLine p) {
        this.process = p;
    }

    private File customProfileDir() {
        if (this.customProfileDir == null) {
            this.customProfileDir = LauncherUtils.createCustomProfileDir((String)this.sessionId);
        }
        return this.customProfileDir;
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir(), "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            Sleeper.sleepTight((long)500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }
}

