/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.iphone;

import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneDriver
extends RemoteWebDriver
implements TakesScreenshot,
WebStorage {
    protected static final String DEFAULT_IWEBDRIVER_URL = "http://localhost:3001/wd/hub";

    public IPhoneDriver(CommandExecutor executor) {
        super(executor, (Capabilities)DesiredCapabilities.iphone());
    }

    public IPhoneDriver(URL remoteAddress) throws Exception {
        super(remoteAddress, (Capabilities)DesiredCapabilities.iphone());
    }

    public IPhoneDriver(String remoteAddress) throws Exception {
        this(new URL(remoteAddress));
    }

    public IPhoneDriver() throws Exception {
        this(DEFAULT_IWEBDRIVER_URL);
    }

    public IPhoneDriver(Capabilities ignored) throws Exception {
        this();
    }

    public void close() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public WebDriver.TargetLocator switchTo() {
        return new IPhoneTargetLocator();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        byte[] base64Png = (byte[])this.execute("screenshot").getValue();
        String png = new String(base64Png);
        return (X)target.convertFromBase64Png(png);
    }

    public LocalStorage getLocalStorage() {
        return new IPhoneStorage(STORAGE_TYPE.local);
    }

    public SessionStorage getSessionStorage() {
        return new IPhoneStorage(STORAGE_TYPE.session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IPhoneStorage
    implements LocalStorage,
    SessionStorage {
        private STORAGE_TYPE t;

        public IPhoneStorage(STORAGE_TYPE type) {
            this.t = type;
        }

        public String getItem(String key) {
            return (String)IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "getLocalStorageItem" : "getSessionStorageItem", (Map)ImmutableMap.of((Object)"key", (Object)key)).getValue();
        }

        public Set<String> keySet() {
            return new HashSet<String>((List)IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "getLocalStorageKeys" : "getSessionStorageKey").getValue());
        }

        public void setItem(String key, String value) {
            IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "setLocalStorageItem" : "setSessionStorageItem", (Map)ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value));
        }

        public String removeItem(String key) {
            return (String)IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "removeLocalStorageItem" : "removeSessionStorageItem", (Map)ImmutableMap.of((Object)"key", (Object)key)).getValue();
        }

        public void clear() {
            IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "clearLocalStorage" : "clearSessionStorage");
        }

        public int size() {
            return ((Number)IPhoneDriver.this.execute(this.t == STORAGE_TYPE.local ? "getLocalStorageSize" : "getSessionStorageSize").getValue()).intValue();
        }
    }

    private class IPhoneTargetLocator
    extends RemoteWebDriver.RemoteTargetLocator {
        private IPhoneTargetLocator() {
            super((RemoteWebDriver)IPhoneDriver.this);
        }

        public WebElement activeElement() {
            return (WebElement)IPhoneDriver.this.executeScript("return document.activeElement || document.body;", new Object[0]);
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert()");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STORAGE_TYPE {
        local,
        session;

    }
}

