/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Throwables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS = "ignoreProtectedModeSettings";
    private WindowsProxyManager proxyManager;

    public InternetExplorerDriver() {
        this.assertOnWindows();
        this.setup((Capabilities)DesiredCapabilities.internetExplorer(), 0);
    }

    public InternetExplorerDriver(Capabilities capabilities) {
        this.assertOnWindows();
        this.proxyManager = new WindowsProxyManager(true, "webdriver-ie", 0, 0);
        this.prepareProxy(capabilities);
        this.setup(capabilities, 0);
    }

    public InternetExplorerDriver(int port) {
        this.assertOnWindows();
        this.setup((Capabilities)DesiredCapabilities.internetExplorer(), port);
    }

    public InternetExplorerDriver(InternetExplorerDriverService service) {
        this(service, (Capabilities)DesiredCapabilities.internetExplorer());
    }

    public InternetExplorerDriver(InternetExplorerDriverService service, Capabilities capabilities) {
        this.assertOnWindows();
        this.setCommandExecutor((CommandExecutor)new DriverCommandExecutor((DriverService)service));
        this.startSession(capabilities);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", current));
        }
    }

    private void setup(Capabilities capabilities, int port) {
        this.setupService(port);
        this.startSession(capabilities);
    }

    private void setupService(int port) {
        try {
            InternetExplorerDriverService service = new InternetExplorerDriverService.Builder().usingPort(port).build();
            this.setCommandExecutor((CommandExecutor)new DriverCommandExecutor((DriverService)service));
        }
        catch (IllegalStateException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null) {
            return;
        }
        this.proxyManager.backupRegistrySettings();
        this.proxyManager.changeRegistrySettings(caps);
        Thread cleanupThread = new Thread(){

            @Override
            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }
}

