/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeExtension;
import org.openqa.selenium.chrome.ChromeProfile;
import org.openqa.selenium.remote.internal.CircularOutputStream;
import org.openqa.selenium.remote.internal.SubProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeBinary {
    private static final String CHROME_LOG_FILE_PROPERTY = "webdriver.chrome.logFile";
    private static final int BACKOFF_INTERVAL = 2500;
    private volatile int linearBackoffCoefficient = 1;
    private final ChromeProfile profile;
    private final ChromeExtension extension;
    private final int port;
    private final SubProcess chromeProcess;
    private List<String> customFlags = new ArrayList<String>();
    protected String chromeBinaryLocation = null;

    public ChromeBinary(ChromeProfile profile, ChromeExtension extension) {
        this(profile, extension, 0);
    }

    public ChromeBinary(ChromeProfile profile, ChromeExtension extension, int port) {
        ProcessBuilder builder;
        this.profile = profile;
        this.extension = extension;
        this.port = port == 0 ? ChromeBinary.findFreePort() : port;
        String serverUrl = String.format("http://localhost:%d/chromeCommandExecutor", this.port);
        try {
            List<String> commandline = this.getCommandline(serverUrl);
            builder = new ProcessBuilder(commandline);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        File logFile = ChromeBinary.getLogFile();
        this.chromeProcess = logFile == null ? new SubProcess(builder) : new SubProcess(builder, (OutputStream)new CircularOutputStream(logFile));
    }

    private static File getLogFile() {
        String logFile = System.getProperty(CHROME_LOG_FILE_PROPERTY);
        return logFile == null ? null : new File(logFile);
    }

    private static int findFreePort() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void addCustomBinaryFlag(String flag) {
        this.customFlags.add(flag);
    }

    public ChromeProfile getProfile() {
        return this.profile;
    }

    public ChromeExtension getExtension() {
        return this.extension;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        this.chromeProcess.launch();
        try {
            Thread.sleep(2500 * this.linearBackoffCoefficient);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    List<String> getCommandline(String serverUrl) throws IOException {
        ArrayList commandline = Lists.newArrayList((Object[])new String[]{this.getChromeBinaryLocation(), "--load-extension=" + this.extension.getDirectory().getAbsolutePath(), "--activate-on-launch", "--homepage=about:blank", "--no-first-run", "--disable-hang-monitor", "--disable-popup-blocking", "--disable-prompt-on-repost", "--no-default-browser-check", this.profile.getUntrustedCertificatesFlag()});
        commandline.addAll(this.customFlags);
        if (!this.profile.equals(ChromeProfile.DEFAULT_PROFILE)) {
            commandline.add("--user-data-dir=" + this.profile.getDirectory().getAbsolutePath());
        }
        this.appendProxyArguments(commandline).add(serverUrl);
        return commandline;
    }

    private List<String> appendProxyArguments(List<String> commandline) {
        Proxy proxy = this.profile.getProxy();
        if (proxy == null) {
            return commandline;
        }
        if (proxy.getProxyAutoconfigUrl() != null) {
            commandline.add("--proxy-pac-url=" + proxy.getProxyAutoconfigUrl());
        } else if (proxy.getHttpProxy() != null) {
            commandline.add("--proxy-server=" + proxy.getHttpProxy());
        } else if (proxy.isAutodetect()) {
            commandline.add("--proxy-auto-detect");
        } else if (proxy.getProxyType() == Proxy.ProxyType.DIRECT) {
            commandline.add("--no-proxy-server");
        } else if (proxy.getProxyType() != Proxy.ProxyType.SYSTEM) {
            throw new IllegalStateException("Unsupported proxy setting");
        }
        return commandline;
    }

    public boolean isRunning() {
        return this.chromeProcess.isRunning();
    }

    public void kill() {
        this.chromeProcess.shutdown();
    }

    public void incrementBackoffBy(int diff) {
        this.linearBackoffCoefficient += diff;
    }

    protected String getChromeBinaryLocation() throws IOException {
        if (!this.isChromeBinaryLocationKnown()) {
            this.chromeBinaryLocation = System.getProperty("webdriver.chrome.bin");
            if (this.chromeBinaryLocation == null) {
                ArrayList<String> paths = new ArrayList<String>();
                if (Platform.getCurrent().is(Platform.WINDOWS)) {
                    paths.add(ChromeBinary.getWindowsBinaryLocationFromRegistry());
                    paths.add(ChromeBinary.getDefaultWindowsBinaryLocation());
                } else if (Platform.getCurrent().is(Platform.UNIX)) {
                    paths.add("/usr/bin/google-chrome");
                    paths.add("/usr/bin/chromium");
                } else if (Platform.getCurrent().is(Platform.MAC)) {
                    paths.add("/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
                    paths.add("/Users/" + System.getProperty("user.name") + "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
                } else {
                    throw new WebDriverException("Unsupported operating system.  Could not locate Chrome.  Set webdriver.chrome.bin");
                }
                for (String path : paths) {
                    File binary = new File(path);
                    if (!binary.exists()) continue;
                    this.chromeBinaryLocation = binary.getCanonicalFile().getAbsoluteFile().toString();
                    break;
                }
            }
            if (!this.isChromeBinaryLocationKnown()) {
                throw new WebDriverException("Couldn't locate Chrome.  Set webdriver.chrome.bin");
            }
        }
        return this.chromeBinaryLocation;
    }

    protected boolean isChromeBinaryLocationKnown() {
        return this.chromeBinaryLocation != null && new File(this.chromeBinaryLocation).exists();
    }

    protected static final String getWindowsBinaryLocationFromRegistry() {
        if (!Platform.WINDOWS.is(Platform.getCurrent())) {
            throw new UnsupportedOperationException("Cannot get registry value on non-Windows systems");
        }
        try {
            String line;
            Process process = Runtime.getRuntime().exec("reg query \"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\chrome.exe\" /v \"\"");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            process.waitFor();
            while ((line = reader.readLine()) != null) {
                if (!line.contains("    ")) continue;
                String[] tokens = line.split("REG_SZ");
                return tokens[tokens.length - 1].trim();
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected static final String getDefaultWindowsBinaryLocation() {
        StringBuilder path = new StringBuilder();
        path.append(System.getProperty("user.home"));
        if (Platform.VISTA.is(Platform.getCurrent())) {
            path.append("\\AppData\\Local");
        } else if (Platform.XP.is(Platform.getCurrent())) {
            path.append("\\Local Settings\\Application Data");
        }
        path.append("\\Google\\Chrome\\Application\\chrome.exe");
        return path.toString();
    }
}

