/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractNpmAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNpmAnalyzer.class);
    public static final String NPM_DEPENDENCY_ECOSYSTEM = "npm";
    private static final String PACKAGE_JSON = "package.json";

    @Override
    public boolean accept(File pathname) {
        boolean accept = super.accept(pathname);
        if (accept) {
            try {
                accept &= this.shouldProcess(pathname);
            }
            catch (AnalysisException ex) {
                throw new UnexpectedAnalysisException(ex.getMessage(), ex.getCause());
            }
        }
        return accept;
    }

    protected boolean shouldProcess(File pathname) throws AnalysisException {
        try {
            String canonicalPath = pathname.getCanonicalPath();
            if (canonicalPath.contains(File.separator + "node_modules" + File.separator) || canonicalPath.contains(File.separator + "bower_components" + File.separator)) {
                LOGGER.debug("Skipping analysis of node/bower module: {}", (Object)canonicalPath);
                return false;
            }
        }
        catch (IOException ex) {
            throw new AnalysisException("Unable to process dependency", ex);
        }
        return true;
    }

    protected Dependency createDependency(Dependency dependency, String name, String version, String scope) {
        Identifier id;
        Dependency nodeModule = new Dependency(new File(dependency.getActualFile() + "?" + name), true);
        nodeModule.setEcosystem(NPM_DEPENDENCY_ECOSYSTEM);
        nodeModule.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", name, version)));
        nodeModule.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", name, Confidence.HIGHEST);
        nodeModule.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name", name, Confidence.HIGH);
        if (!StringUtils.isBlank((CharSequence)version)) {
            nodeModule.addEvidence(EvidenceType.VERSION, PACKAGE_JSON, "version", version, Confidence.HIGHEST);
            nodeModule.setVersion(version);
        }
        if (dependency.getName() != null) {
            nodeModule.addProjectReference(dependency.getName() + ": " + scope);
        } else {
            nodeModule.addProjectReference(dependency.getDisplayFileName() + ": " + scope);
        }
        nodeModule.setName(name);
        try {
            PackageURL purl = PackageURLBuilder.aPackageURL().withType(NPM_DEPENDENCY_ECOSYSTEM).withName(name).withVersion(version).build();
            id = new PurlIdentifier(purl, Confidence.HIGHEST);
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to generate Purl - using a generic identifier instead " + ex.getMessage());
            id = new GenericIdentifier(String.format("npm:%s@%s", dependency.getName(), version), Confidence.HIGHEST);
        }
        nodeModule.addSoftwareIdentifier(id);
        return nodeModule;
    }

    protected void processPackage(Engine engine, Dependency dependency, JsonArray jsonArray, String depType) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        jsonArray.getValuesAs(JsonString.class).forEach(str -> builder.add(str.toString(), ""));
        JsonObject jsonObject = builder.build();
        this.processPackage(engine, dependency, jsonObject, depType);
    }

    protected void processPackage(Engine engine, Dependency dependency, JsonObject jsonObject, String depType) {
        for (int i = 0; i < jsonObject.size(); ++i) {
            jsonObject.entrySet().forEach(entry -> {
                Dependency existing;
                String name = (String)entry.getKey();
                String version = "";
                if (entry.getValue() != null && ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                    version = ((JsonString)entry.getValue()).getString();
                }
                if ((existing = this.findDependency(engine, name, version)) == null) {
                    Dependency nodeModule = this.createDependency(dependency, name, version, depType);
                    engine.addDependency(nodeModule);
                } else {
                    existing.addProjectReference(dependency.getName() + ": " + depType);
                }
            });
        }
    }

    private static String addToEvidence(Dependency dep, EvidenceType t, JsonObject json, String key) {
        String evidenceStr = null;
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value instanceof JsonString) {
                evidenceStr = ((JsonString)value).getString();
                dep.addEvidence(t, PACKAGE_JSON, key, evidenceStr, Confidence.HIGHEST);
            } else if (value instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)value;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String property = (String)entry.getKey();
                    JsonValue subValue = (JsonValue)entry.getValue();
                    if (subValue instanceof JsonString) {
                        evidenceStr = ((JsonString)subValue).getString();
                        dep.addEvidence(t, PACKAGE_JSON, String.format("%s.%s", key, property), evidenceStr, Confidence.HIGHEST);
                        continue;
                    }
                    LOGGER.warn("JSON sub-value not string as expected: {}", (Object)subValue);
                }
            } else {
                LOGGER.warn("JSON value not string or JSON object as expected: {}", (Object)value);
            }
        }
        return evidenceStr;
    }

    protected Dependency findDependency(Engine engine, String name, String version) {
        for (Dependency d : engine.getDependencies()) {
            String dependencyVersion;
            if (!NPM_DEPENDENCY_ECOSYSTEM.equals(d.getEcosystem()) || !name.equals(d.getName()) || version == null || d.getVersion() == null || !DependencyBundlingAnalyzer.npmVersionsMatch(version, dependencyVersion = d.getVersion())) continue;
            return d;
        }
        return null;
    }

    public void gatherEvidence(JsonObject json, Dependency dependency) {
        String displayName = null;
        if (json.containsKey((Object)"name")) {
            Object value = json.get((Object)"name");
            if (value instanceof JsonString) {
                String valueString;
                displayName = valueString = ((JsonString)value).getString();
                dependency.setName(valueString);
                dependency.setPackagePath(valueString);
                dependency.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                dependency.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name", valueString, Confidence.HIGH);
            } else {
                LOGGER.warn("JSON value not string as expected: {}", value);
            }
        }
        String desc = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.PRODUCT, json, "description");
        dependency.setDescription(desc);
        String vendor = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VENDOR, json, "author");
        String version = AbstractNpmAnalyzer.addToEvidence(dependency, EvidenceType.VERSION, json, "version");
        if (version != null) {
            Identifier id;
            displayName = String.format("%s:%s", displayName, version);
            dependency.setVersion(version);
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType(NPM_DEPENDENCY_ECOSYSTEM).withName(dependency.getName()).withVersion(version).build();
                id = new PurlIdentifier(purl, Confidence.HIGHEST);
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to generate Purl - using a generic identifier instead " + ex.getMessage());
                id = new GenericIdentifier(String.format("npm:%s:%s", dependency.getName(), version), Confidence.HIGHEST);
            }
            dependency.addSoftwareIdentifier(id);
        }
        if (displayName != null) {
            dependency.setDisplayFileName(displayName);
            dependency.setPackagePath(displayName);
        } else {
            LOGGER.warn("Unable to determine package name or version for {}", (Object)dependency.getActualFilePath());
            if (vendor != null && !vendor.isEmpty()) {
                dependency.setDisplayFileName(String.format("%s package.json", vendor));
            }
        }
        if (json.containsKey((Object)"license")) {
            Object value = json.get((Object)"license");
            if (value instanceof JsonString) {
                dependency.setLicense(json.getString("license"));
            } else if (value instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                StringBuilder sb = new StringBuilder();
                boolean addComma = false;
                for (int x = 0; x < array.size(); ++x) {
                    if (array.isNull(x)) continue;
                    if (addComma) {
                        sb.append(", ");
                    } else {
                        addComma = true;
                    }
                    if (JsonValue.ValueType.STRING == ((JsonValue)array.get(x)).getValueType()) {
                        sb.append(array.getString(x));
                        continue;
                    }
                    JsonObject lo = array.getJsonObject(x);
                    if (lo.containsKey((Object)"type") && !lo.isNull("type") && lo.containsKey((Object)"url") && !lo.isNull("url")) {
                        String license = String.format("%s (%s)", lo.getString("type"), lo.getString("url"));
                        sb.append(license);
                        continue;
                    }
                    if (lo.containsKey((Object)"type") && !lo.isNull("type")) {
                        sb.append(lo.getString("type"));
                        continue;
                    }
                    if (!lo.containsKey((Object)"url") || lo.isNull("url")) continue;
                    sb.append(lo.getString("url"));
                }
                dependency.setLicense(sb.toString());
            } else {
                dependency.setLicense(json.getJsonObject("license").getString("type"));
            }
        }
    }
}

