/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.ossindex;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.message.BasicHeader;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.BasicAuthHelper;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public class ODCConnectionTransport
implements Transport {
    private final OssindexClientConfiguration configuration;
    private final UserAgentSupplier userAgent;

    public ODCConnectionTransport(OssindexClientConfiguration config, UserAgentSupplier userAgent) {
        this.userAgent = userAgent;
        this.configuration = config;
    }

    public void init(OssindexClientConfiguration configuration) {
    }

    public String post(URI url, String payloadType, String payload, String acceptType) throws Transport.TransportException, IOException {
        try {
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(3);
            headers.add(new BasicHeader("Accept", (Object)acceptType));
            headers.add(new BasicHeader("User-Agent", (Object)this.userAgent.get()));
            String authorization = BasicAuthHelper.authorizationHeader((AuthConfiguration)this.configuration.getAuthConfiguration());
            if (authorization != null) {
                headers.add(new BasicHeader("Authorization", (Object)authorization));
            }
            return Downloader.getInstance().postBasedFetchContent(url, payload, ContentType.create((String)payloadType, (Charset)StandardCharsets.UTF_8), headers);
        }
        catch (TooManyRequestsException e) {
            throw new Transport.TransportException("Too many requests for " + url.toString() + " HTTP status 429", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new Transport.TransportException("Not found for " + url.toString() + "HTTP status 404", (Throwable)e);
        }
    }

    public void close() throws Exception {
    }
}

