/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.artifactory;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.owasp.dependencycheck.data.artifactory.ChecksumsImpl;
import org.owasp.dependencycheck.data.artifactory.FileImpl;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArtifactorySearchResponseHandler
implements HttpClientResponseHandler<List<MavenArtifact>> {
    private static final Pattern PATH_PATTERN = Pattern.compile("^/(?<groupId>.+)/(?<artifactId>[^/]+)/(?<version>[^/]+)/[^/]+$");
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactorySearchResponseHandler.class);
    private final ObjectReader fileImplReader = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(FileImpl.class);
    private final Dependency expectedDependency;

    ArtifactorySearchResponseHandler(Dependency dependency) {
        this.expectedDependency = dependency;
    }

    protected boolean init(JsonParser parser) throws IOException {
        JsonToken nextToken = parser.nextToken();
        if (nextToken != JsonToken.START_OBJECT) {
            throw new IOException("Expected " + String.valueOf(JsonToken.START_OBJECT) + ", got " + String.valueOf(nextToken));
        }
        while ((nextToken = parser.nextToken()) != null) {
            if (!nextToken.isStructStart()) continue;
            if (nextToken == JsonToken.START_ARRAY && "results".equals(parser.currentName())) {
                return true;
            }
            parser.skipChildren();
        }
        return false;
    }

    private boolean checkHashes(ChecksumsImpl checksums) {
        String md5sum = this.expectedDependency.getMd5sum();
        String hashMismatchFormat = "Artifact found by API is not matching the {} of the artifact (repository hash is {} while actual is {}) !";
        boolean match = true;
        if (!checksums.getMd5().equals(md5sum)) {
            LOGGER.warn("Artifact found by API is not matching the {} of the artifact (repository hash is {} while actual is {}) !", new Object[]{"md5", md5sum, checksums.getMd5()});
            match = false;
        }
        String sha1sum = this.expectedDependency.getSha1sum();
        if (!checksums.getSha1().equals(sha1sum)) {
            LOGGER.warn("Artifact found by API is not matching the {} of the artifact (repository hash is {} while actual is {}) !", new Object[]{"sha1", sha1sum, checksums.getSha1()});
            match = false;
        }
        String sha256sum = this.expectedDependency.getSha256sum();
        if (checksums.getSha256() != null && !checksums.getSha256().equals(sha256sum)) {
            LOGGER.warn("Artifact found by API is not matching the {} of the artifact (repository hash is {} while actual is {}) !", new Object[]{"sha256", sha256sum, checksums.getSha256()});
            match = false;
        }
        return match;
    }

    public List<MavenArtifact> handleResponse(ClassicHttpResponse response) throws IOException {
        ArrayList<MavenArtifact> result;
        block15: {
            result = new ArrayList<MavenArtifact>();
            try (InputStreamReader streamReader = new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8);
                 JsonParser parser = this.fileImplReader.getFactory().createParser((Reader)streamReader);){
                if (this.init(parser) && parser.nextToken() == JsonToken.START_OBJECT) {
                    do {
                        FileImpl file;
                        if ((file = (FileImpl)this.fileImplReader.readValue(parser)).getChecksums() == null) {
                            LOGGER.warn("No checksums found in artifactory search result of uri {}. Please make sure that header X-Result-Detail is retained on any (reverse)-proxy, loadbalancer or WebApplicationFirewall in the network path to your Artifactory Server", (Object)file.getUri());
                            continue;
                        }
                        Optional<Matcher> validationResult = this.validateUsability(file);
                        if (validationResult.isEmpty()) continue;
                        Matcher pathMatcher = validationResult.get();
                        String groupId = pathMatcher.group("groupId").replace('/', '.');
                        String artifactId = pathMatcher.group("artifactId");
                        String version = pathMatcher.group("version");
                        result.add(new MavenArtifact(groupId, artifactId, version, file.getDownloadUri(), MavenArtifact.derivePomUrl(artifactId, version, file.getDownloadUri())));
                    } while (parser.nextToken() == JsonToken.START_OBJECT);
                    break block15;
                }
                throw new FileNotFoundException("Artifact " + String.valueOf(this.expectedDependency) + " not found in Artifactory");
            }
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException("Artifact " + String.valueOf(this.expectedDependency) + " not found in Artifactory; discovered sha1 hits not recognized as matching maven artifacts");
        }
        return result;
    }

    private Optional<Matcher> validateUsability(FileImpl file) {
        Optional<Matcher> result;
        if (!this.checkHashes(file.getChecksums())) {
            result = Optional.empty();
        } else {
            Matcher pathMatcher = PATH_PATTERN.matcher(file.getPath());
            if (!pathMatcher.matches()) {
                LOGGER.debug("Cannot extract the Maven information from the path retrieved in Artifactory {}", (Object)file.getPath());
                result = Optional.empty();
            } else {
                result = Optional.of(pathMatcher);
            }
        }
        return result;
    }
}

