/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PoetryAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoetryAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "python";
    private static final String POETRY_LOCK = "poetry.lock";
    private static final String PYPROJECT_TOML = "pyproject.toml";
    private static final FileFilter POETRY_LOCK_FILTER = FileFilterBuilder.newInstance().addFilenames("poetry.lock", "pyproject.toml").build();

    @Override
    public String getName() {
        return "Poetry Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.poetry.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return POETRY_LOCK_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
        engine.removeDependency(dependency);
        Optional<Toml> potentiallyParsedToml = this.parseDependencyFile(dependency);
        if (potentiallyParsedToml.isEmpty()) {
            LOGGER.warn("toml file skipped: {} could not be parsed", (Object)dependency.getActualFilePath());
            return;
        }
        Toml result = potentiallyParsedToml.get();
        if (PYPROJECT_TOML.equals(dependency.getActualFile().getName())) {
            if (result.getTable("tool.poetry") == null) {
                LOGGER.debug("skipping {} as it does not contain `tool.poetry`", (Object)dependency.getDisplayFileName());
                return;
            }
            File parentPath = dependency.getActualFile().getParentFile();
            this.ensureLock(parentPath);
            return;
        }
        List projectsLocks = result.getTables("package");
        if (projectsLocks == null) {
            return;
        }
        projectsLocks.forEach(project -> {
            String name = project.getString("name");
            String version = project.getString("version");
            LOGGER.debug(String.format("package, version: %s %s", name, version));
            Dependency d = new Dependency(dependency.getActualFile(), true);
            d.setName(name);
            d.setVersion(version);
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("pypi").withName(name).withVersion(version).build();
                d.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for pypi", (Throwable)ex);
                d.addSoftwareIdentifier(new GenericIdentifier("pypi:" + name + "@" + version, Confidence.HIGH));
            }
            d.setPackagePath(String.format("%s:%s", name, version));
            d.setEcosystem(DEPENDENCY_ECOSYSTEM);
            String filePath = String.format("%s:%s/%s", dependency.getFilePath(), name, version);
            d.setFilePath(filePath);
            d.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
            d.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
            d.setMd5sum(Checksum.getMD5Checksum((String)filePath));
            d.addEvidence(EvidenceType.PRODUCT, POETRY_LOCK, "product", name, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VERSION, POETRY_LOCK, "version", version, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VENDOR, POETRY_LOCK, "vendor", name, Confidence.HIGHEST);
            engine.addDependency(d);
        });
    }

    private Optional<Toml> parseDependencyFile(Dependency dependency) {
        try {
            Toml toml = new Toml().read(dependency.getActualFile());
            return Optional.of(toml);
        }
        catch (RuntimeException e) {
            Optional<String> unparsableFileErrorMessage = Optional.ofNullable(e.getCause()).filter(c -> c instanceof IllegalStateException).map(Throwable::getMessage).filter(PoetryAnalyzer::isInvalidKeyErrorMessage);
            if (unparsableFileErrorMessage.isPresent()) {
                String message = String.format("Invalid toml file, cannot parse '%s'", dependency.getActualFile());
                LOGGER.debug(message, (Throwable)e);
                return Optional.empty();
            }
            throw e;
        }
    }

    private static boolean isInvalidKeyErrorMessage(String m) {
        return m.startsWith("Invalid key");
    }

    private void ensureLock(File parent) throws AnalysisException {
        boolean found;
        File lock = new File(parent, POETRY_LOCK);
        File requirements = new File(parent, "requirements.txt");
        boolean bl = found = lock.isFile() || requirements.isFile();
        if (!found && !parent.toString().contains("node_modules")) {
            throw new AnalysisException("Python `pyproject.toml` found and there is not a `poetry.lock` or `requirements.txt` - analysis will be incomplete");
        }
    }
}

