/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class CMLFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new CMLFormat();
        }
        return myself;
    }

    public String getFormatName() {
        return "Chemical Markup Language";
    }

    public String getMIMEType() {
        return "chemical/x-cml";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"cml", "xml"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.CMLReader";
    }

    public String getWriterClassName() {
        return "org.openscience.cdk.io.CMLWriter";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.indexOf("http://www.xml-cml.org/schema") != -1 || line.indexOf("<atom") != -1 || line.indexOf("<molecule") != -1 || line.indexOf("<reaction") != -1 || line.indexOf("<cml") != -1 || line.indexOf("<bond") != -1;
    }

    public boolean isXMLBased() {
        return true;
    }

    public int getSupportedDataFeatures() {
        return 955;
    }

    public int getRequiredDataFeatures() {
        return 0;
    }
}

