/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternManipulator;

public class IsotopePatternSimilarity {
    private double chargeToAdd;
    private double tolerance_ppm = 1.0;
    private static final double massE = 5.485E-4;

    public void seTolerance(double tolerance) {
        this.tolerance_ppm = tolerance;
    }

    public double getTolerance() {
        return this.tolerance_ppm;
    }

    public double compare(IsotopePattern isoto1, IsotopePattern isoto2) {
        IsotopePattern iso1 = IsotopePatternManipulator.sortAndNormalizedByIntensity(isoto1);
        IsotopePattern iso2 = IsotopePatternManipulator.sortAndNormalizedByIntensity(isoto2);
        this.chargeToAdd = isoto1.getCharge() == 1.0 ? 5.485E-4 : (isoto1.getCharge() == -1.0 ? -5.485E-4 : 0.0);
        for (IsotopeContainer isoC : iso1.getIsotopes()) {
            double mass = isoC.getMass();
            isoC.setMass(mass + this.chargeToAdd);
        }
        double totalFactor = 0.0;
        double score = 0.0;
        int length = iso1.getNumberOfIsotopes();
        for (int i = 0; i < length; ++i) {
            IsotopeContainer isoContainer = iso1.getIsotopes().get(i);
            double factor = isoContainer.getIntensity();
            totalFactor += factor;
            int closestDp = this.getClosestDataDiff(isoContainer, iso2);
            if (closestDp == -1) continue;
            double diffMass = isoContainer.getMass() - iso2.getIsotopes().get(closestDp).getMass();
            diffMass = Math.abs(diffMass);
            double diffAbun = 1.0 - isoContainer.getIntensity() / iso2.getIsotopes().get(closestDp).getIntensity();
            double tempScore = 1.0 - (diffMass + (diffAbun = Math.abs(diffAbun)));
            if (tempScore < 0.0) {
                tempScore = 0.0;
            }
            score += tempScore * factor;
        }
        return score / totalFactor;
    }

    private int getClosestDataDiff(IsotopeContainer isoContainer, IsotopePattern pattern) {
        double diff = 100.0;
        int posi = -1;
        for (int i = 0; i < pattern.getNumberOfIsotopes(); ++i) {
            double tempDiff = Math.abs(isoContainer.getMass() - pattern.getIsotopes().get(i).getMass());
            if (!(tempDiff <= this.tolerance_ppm / isoContainer.getMass()) || !(tempDiff < diff)) continue;
            diff = tempDiff;
            posi = i;
        }
        return posi;
    }
}

