/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternManipulator;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class IsotopePatternGenerator {
    private IChemObjectBuilder builder = null;
    private IsotopeFactory isoFactory;
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopePatternGenerator.class);
    private double minIntensity = 1.0E-5;
    private double minAbundance = 1.0E-10;
    private double resolution = 5.0E-5f;
    private boolean storeFormula = false;

    public IsotopePatternGenerator() {
        this(0.1);
    }

    public IsotopePatternGenerator(double minIntensity) {
        this.minIntensity = minIntensity;
        this.logger.info((Object)"Generating all Isotope structures with IsotopeGenerator");
    }

    public IsotopePatternGenerator setMinIntensity(double minIntensity) {
        this.minIntensity = minIntensity;
        return this;
    }

    public IsotopePatternGenerator setMinResolution(double resolution) {
        this.resolution = resolution;
        return this;
    }

    public IsotopePatternGenerator setStoreFormulas(boolean storeFormula) {
        this.storeFormula = storeFormula;
        return this;
    }

    public IsotopePattern getIsotopes(IMolecularFormula molFor) {
        if (this.builder == null) {
            try {
                this.isoFactory = Isotopes.getInstance();
                this.builder = molFor.getBuilder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String mf = MolecularFormulaManipulator.getString(molFor, true);
        IMolecularFormula molecularFormula = MolecularFormulaManipulator.getMajorIsotopeMolecularFormula(mf, this.builder);
        IsotopePattern abundance_Mass = null;
        for (IIsotope isos : molecularFormula.isotopes()) {
            String elementSymbol = isos.getSymbol();
            int atomCount = molecularFormula.getIsotopeCount(isos);
            ArrayList<IsotopeContainer> additional = new ArrayList<IsotopeContainer>();
            for (IIsotope isotope : this.isoFactory.getIsotopes(elementSymbol)) {
                double mass = isotope.getExactMass();
                double abundance = isotope.getNaturalAbundance();
                if (abundance <= 1.0E-9) continue;
                IsotopeContainer container = new IsotopeContainer(mass, abundance);
                if (this.storeFormula) {
                    container.setFormula(this.asFormula(isotope));
                }
                additional.add(container);
            }
            for (int i = 0; i < atomCount; ++i) {
                abundance_Mass = this.calculateAbundanceAndMass(abundance_Mass, additional);
            }
        }
        IsotopePattern isoP = IsotopePatternManipulator.sortAndNormalizedByIntensity(abundance_Mass);
        isoP = this.cleanAbundance(isoP, this.minIntensity);
        IsotopePattern isoPattern = IsotopePatternManipulator.sortByMass(isoP);
        return isoPattern;
    }

    private IMolecularFormula asFormula(IIsotope isotope) {
        IMolecularFormula mf = (IMolecularFormula)this.builder.newInstance(IMolecularFormula.class, new Object[0]);
        mf.addIsotope(isotope);
        return mf;
    }

    private IMolecularFormula union(IMolecularFormula a, IMolecularFormula b) {
        IMolecularFormula mf = (IMolecularFormula)this.builder.newInstance(IMolecularFormula.class, new Object[0]);
        mf.add(a);
        mf.add(b);
        return mf;
    }

    private static IsotopeContainer findExisting(List<IsotopeContainer> containers, double mass, double treshhold) {
        for (IsotopeContainer container : containers) {
            if (!(Math.abs(container.getMass() - mass) <= treshhold)) continue;
            return container;
        }
        return null;
    }

    private void addDistinctFormula(IsotopeContainer container, IMolecularFormula mf) {
        for (IMolecularFormula curr : container.getFormulas()) {
            if (!MolecularFormulaManipulator.compare(curr, mf)) continue;
            return;
        }
        container.addFormula(mf);
    }

    private IsotopePattern calculateAbundanceAndMass(IsotopePattern current, List<IsotopeContainer> additional) {
        if (additional == null || additional.size() == 0) {
            return current;
        }
        ArrayList<IsotopeContainer> containers = new ArrayList<IsotopeContainer>();
        if (current == null) {
            current = new IsotopePattern();
            for (IsotopeContainer container : additional) {
                current.addIsotope(container);
            }
        } else {
            for (IsotopeContainer container : current.getIsotopes()) {
                for (IsotopeContainer other : additional) {
                    double abundance = container.getIntensity() * other.getIntensity() * 0.01;
                    double mass = container.getMass() + other.getMass();
                    IsotopeContainer existing = IsotopePatternGenerator.findExisting(containers, mass, this.resolution);
                    if (existing != null) {
                        double newIntensity = existing.getIntensity() + abundance;
                        existing.setMass((existing.getMass() * existing.getIntensity() + mass * abundance) / newIntensity);
                        existing.setIntensity(newIntensity);
                        if (!this.storeFormula) continue;
                        for (IMolecularFormula mf : container.getFormulas()) {
                            this.addDistinctFormula(existing, this.union(mf, other.getFormula()));
                        }
                        continue;
                    }
                    if (!(abundance > this.minAbundance)) continue;
                    IsotopeContainer newcontainer = new IsotopeContainer(mass, abundance);
                    if (this.storeFormula) {
                        for (IMolecularFormula mf : container.getFormulas()) {
                            newcontainer.addFormula(this.union(mf, other.getFormula()));
                        }
                    }
                    containers.add(newcontainer);
                }
            }
            current = new IsotopePattern();
            for (IsotopeContainer container : containers) {
                current.addIsotope(container);
            }
        }
        return current;
    }

    private IsotopePattern cleanAbundance(IsotopePattern isopattern, double minIntensity) {
        double intensity;
        double biggestIntensity = 0.0;
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if (!(intensity > biggestIntensity)) continue;
            biggestIntensity = intensity;
        }
        for (IsotopeContainer sc : isopattern.getIsotopes()) {
            intensity = sc.getIntensity();
            if ((intensity /= biggestIntensity) < 0.0) {
                intensity = 0.0;
            }
            sc.setIntensity(intensity);
        }
        IsotopePattern sortedIsoPattern = new IsotopePattern();
        sortedIsoPattern.setMonoIsotope(new IsotopeContainer(isopattern.getIsotopes().get(0)));
        for (int i = 1; i < isopattern.getNumberOfIsotopes(); ++i) {
            if (!(isopattern.getIsotopes().get(i).getIntensity() >= minIntensity)) continue;
            IsotopeContainer container = new IsotopeContainer(isopattern.getIsotopes().get(i));
            sortedIsoPattern.addIsotope(container);
        }
        return sortedIsoPattern;
    }
}

