/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.MolecularFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugMolecularFormula
extends MolecularFormula
implements IMolecularFormula {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugMolecularFormula.class);

    public IMolecularFormula add(IMolecularFormula formula) {
        this.logger.debug((Object)"Adding formula: ", new Object[]{formula});
        return super.add(formula);
    }

    public IMolecularFormula addIsotope(IIsotope isotope) {
        this.logger.debug((Object)"Adding isotope: ", new Object[]{isotope});
        return super.addIsotope(isotope);
    }

    public IMolecularFormula addIsotope(IIsotope isotope, int count) {
        this.logger.debug((Object)"Adding 'count' isotopes: ", new Object[]{isotope});
        return super.addIsotope(isotope, count);
    }

    public boolean contains(IIsotope isotope) {
        this.logger.debug((Object)"Contains isotope?: ", new Object[]{isotope});
        return super.contains(isotope);
    }

    public Integer getCharge() {
        Integer charge = super.getCharge();
        this.logger.debug((Object)"Getting charge: ", new Object[]{charge});
        return charge;
    }

    public int getIsotopeCount(IIsotope isotope) {
        this.logger.debug((Object)"Getting isotope count for: ", new Object[]{isotope});
        return super.getIsotopeCount(isotope);
    }

    public int getIsotopeCount() {
        this.logger.debug((Object)"Getting isotope count: ", new Object[]{super.getIsotopeCount()});
        return super.getIsotopeCount();
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties...");
        return super.getProperties();
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)("Getting property: " + description));
        return (T)super.getProperty(description);
    }

    public Iterable<IIsotope> isotopes() {
        this.logger.debug((Object)"Getting isotope iterator..");
        return super.isotopes();
    }

    public void removeAllIsotopes() {
        this.logger.debug((Object)"Removing all isotopes...");
        super.removeAllIsotopes();
    }

    public void removeIsotope(IIsotope isotope) {
        this.logger.debug((Object)"Removing this isotope: ", new Object[]{isotope});
        super.removeIsotope(isotope);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)("Removing property: " + description));
        super.removeProperty(description);
    }

    public void setCharge(Integer charge) {
        this.logger.debug((Object)"Setting the charge to: ", new Object[]{charge});
        super.setCharge(charge);
    }

    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting new properties...");
        super.setProperties(properties);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)("Setting new property: " + description + " -> " + property));
        super.setProperty(description, property);
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

