/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

@Incubating(since="7.20.0")
public interface TreeObserver {
    default public Tree treeChanged(Cursor cursor, Tree newTree) {
        return newTree;
    }

    default public Tree propertyChanged(String property, Cursor cursor, Tree newTree, Object oldValue, Object newValue) {
        return newTree;
    }

    public static final class Subscription {
        private final TreeObserver observer;
        private final List<Predicate<Tree>> predicates = new ArrayList<Predicate<Tree>>();
        private final @Nullable ObjectDiffer differ;

        public Subscription(TreeObserver observer) {
            this(observer, false);
        }

        public Subscription(TreeObserver observer, boolean diffChanges) {
            this.observer = observer;
            this.differ = diffChanges ? ObjectDifferBuilder.startBuilding().inclusion().resolveUsing(new InclusionResolver(){

                public Inclusion getInclusion(DiffNode node) {
                    if (node.getPropertyAnnotation(Transient.class) != null) {
                        return Inclusion.EXCLUDED;
                    }
                    return Inclusion.DEFAULT;
                }

                public boolean enablesStrictIncludeMode() {
                    return false;
                }
            }).and().build() : null;
        }

        public Subscription subscribe(@Nullable Tree tree) {
            if (tree != null) {
                this.predicates.add(t -> t == tree);
            }
            return this;
        }

        public Subscription subscribeAll() {
            this.predicates.clear();
            this.predicates.add(t -> true);
            return this;
        }

        public Subscription subscribeAll(Tree tree) {
            new TreeVisitor<Tree, Integer>(){

                @Override
                public Tree visit(@Nullable Tree tree, Integer p) {
                    if (tree != null) {
                        this.subscribe(tree);
                    }
                    return super.visit(tree, p);
                }
            }.visit(tree, (Integer)0);
            return this;
        }

        public Subscription subscribeToType(Class<? extends Tree> treeType) {
            return this.subscribe((Tree t) -> treeType.isAssignableFrom(t.getClass()));
        }

        public Subscription subscribe(Predicate<Tree> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public boolean isSubscribed(@Nullable Tree tree) {
            if (tree == null) {
                return false;
            }
            for (Predicate<Tree> predicate : this.predicates) {
                if (!predicate.test(tree)) continue;
                return true;
            }
            return false;
        }

        public <T extends Tree> T treeChanged(Cursor cursor, T after, Tree before) {
            this.observer.treeChanged(cursor, after);
            if (this.differ != null) {
                return this.diff(after, before, cursor);
            }
            return after;
        }

        private <T extends Tree> T diff(T after, Tree before, Cursor cursor) {
            DiffNode diff = this.differ.compare(after, (Object)before);
            AtomicReference t2 = new AtomicReference(after);
            diff.visit((node, visit) -> {
                if (!node.hasChildren() && node.getPropertyName() != null) {
                    t2.set(this.observer.propertyChanged(node.getPropertyName(), cursor, (Tree)t2.get(), node.canonicalGet((Object)before), node.canonicalGet(t2.get())));
                }
            });
            return t2.get();
        }
    }
}

