/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.gradle.toolingapi.Dependency;
import org.openrewrite.gradle.toolingapi.ResolvedDependency;

public interface GradleDependencyConfiguration {
    public String getName();

    public String getDescription();

    public boolean isTransitive();

    public boolean isCanBeConsumed();

    public boolean isCanBeResolved();

    public List<GradleDependencyConfiguration> getExtendsFrom();

    public List<Dependency> getRequested();

    public List<ResolvedDependency> getResolved();

    public static Map<String, org.openrewrite.gradle.marker.GradleDependencyConfiguration> toMarkers(Collection<GradleDependencyConfiguration> configurations) {
        HashMap<String, org.openrewrite.gradle.marker.GradleDependencyConfiguration> results = new HashMap<String, org.openrewrite.gradle.marker.GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration config : configurations) {
            results.put(config.getName(), new org.openrewrite.gradle.marker.GradleDependencyConfiguration(config.getName(), config.getDescription(), config.isTransitive(), config.isCanBeResolved(), config.isCanBeConsumed(), Collections.emptyList(), config.getRequested().stream().map(Dependency::toMarkers).collect(Collectors.toList()), ResolvedDependency.toMarker(config.getResolved()), null, null));
        }
        for (GradleDependencyConfiguration conf : configurations) {
            org.openrewrite.gradle.marker.GradleDependencyConfiguration dc;
            if (conf.getExtendsFrom().isEmpty() || (dc = (org.openrewrite.gradle.marker.GradleDependencyConfiguration)results.get(conf.getName())) == null) continue;
            List extendsFrom = conf.getExtendsFrom().stream().map(it -> (org.openrewrite.gradle.marker.GradleDependencyConfiguration)results.get(it.getName())).collect(Collectors.toList());
            dc.unsafeSetExtendsFrom(extendsFrom);
        }
        return results;
    }
}

