/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2.converters;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.json.DefaultJSONWriter;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONPopulator;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.util.StrutsTypeConverter;

public class JsonConverter
extends StrutsTypeConverter {
    private static final Log log = LogFactory.getLog(JsonConverter.class);

    public Object convertFromString(Map context, String[] values, Class toClass) {
        Object object;
        if (log.isTraceEnabled()) {
            log.trace((Object)("will convertFromString " + Arrays.toString(values)));
        }
        if (values.length == 0) {
            object = null;
        } else if (values.length == 1) {
            String json = values[0];
            if (log.isTraceEnabled()) {
                log.trace((Object)("will deserialize " + json));
            }
            try {
                Map deserialize = (Map)JSONUtil.deserialize((String)json);
                JSONPopulator jsonPopulator = new JSONPopulator();
                object = toClass.newInstance();
                jsonPopulator.populateObject(object, deserialize);
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("unable to parse json =\n" + json), e);
                }
                throw new RuntimeException("unable to parse json = " + json, e);
            }
        } else {
            throw new UnsupportedOperationException("unable to parse multiple values " + Arrays.toString(values));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("convert from string " + Arrays.toString(values) + " will return " + object));
        }
        return object;
    }

    public String convertToString(Map context, Object object) {
        String json;
        if (log.isTraceEnabled()) {
            log.trace((Object)("will serialize " + object));
        }
        if (object == null) {
            json = "null";
        } else {
            try {
                DefaultJSONWriter writer = new DefaultJSONWriter();
                json = writer.write(object);
            }
            catch (JSONException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("unable to serialize object " + object), (Throwable)e);
                }
                throw new RuntimeException("unable to serialize object " + object, e);
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("error while serializing object " + object), t);
                }
                throw new RuntimeException("error while serializing object " + object, t);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("serialize " + object + " will return " + json));
        }
        return json;
    }
}

