/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import java.util.List;
import org.nuiton.topia.TopiaContext;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;
import org.nuiton.web.security.actions.AbstractAction;

public class UserRolesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected SecurityUserDAO securityUserDAO;
    protected SecurityRoleDAO securityRoleDAO;
    protected List<SecurityUser> users;
    protected List<SecurityRole> roles;
    protected List<String> userIds;

    public String input() throws Exception {
        TopiaContext transaction = this.rootContext.beginTransaction();
        this.securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
        this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
        this.users = this.securityUserDAO.findAllWithOrder(new String[]{"login"});
        this.roles = this.securityRoleDAO.findAllWithOrder(new String[]{"name"});
        transaction.closeContext();
        return super.input();
    }

    public List<SecurityUser> getUsers() {
        return this.users;
    }

    public List<SecurityRole> getRoles() {
        return this.roles;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public String execute() throws Exception {
        String result = super.execute();
        if (this.userIds == null) {
            result = this.input();
        } else {
            try {
                TopiaContext transaction = this.rootContext.beginTransaction();
                this.securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
                this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                for (String userId : this.userIds) {
                    SecurityUser securityUser = (SecurityUser)this.securityUserDAO.findByTopiaId(userId);
                    securityUser.clearSecurityRole();
                    String[] roleIds = this.getParameters("roles-" + userId);
                    if (roleIds == null) continue;
                    for (String roleId : roleIds) {
                        SecurityRole secuRole = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                        securityUser.addSecurityRole(secuRole);
                    }
                }
                transaction.commitTransaction();
                transaction.closeContext();
            }
            catch (Exception ex) {
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }
}

