package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public  abstract class TopiaExpressionLinkAbstract extends TopiaEntityAbstract implements TopiaExpressionLink {

    /**
     * Nom de l'attribut en BD : replace

     */
    protected String replace;
    /**
     * Nom de l'attribut en BD : by

     */
    protected String by;
    private static final long serialVersionUID = 3487024382402324017L;

     /**
      * accept :
      * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
      * @param visitor le visiteur de l'entite.
      * @throws TopiaException
      */
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, REPLACE, String.class, replace);
        visitor.visit(this, BY, String.class, by);
        visitor.end(this);
}

     /**
      * setReplace :
      * @param replace 
      */

    @Override    public void setReplace(String replace) {
        String oldValue = this.replace;
        fireOnPreWrite(REPLACE, oldValue, replace);
        this.replace = replace;
        fireOnPostWrite(REPLACE, oldValue, replace);
}

     /**
      * getReplace :
      * @return String 
      */

    @Override    public String getReplace() {
        fireOnPreRead(REPLACE, replace);
        String result = this.replace;
        fireOnPostRead(REPLACE, replace);
        return result;
}

     /**
      * setBy :
      * @param by 
      */

    @Override    public void setBy(String by) {
        String oldValue = this.by;
        fireOnPreWrite(BY, oldValue, by);
        this.by = by;
        fireOnPostWrite(BY, oldValue, by);
}

     /**
      * getBy :
      * @return String 
      */

    @Override    public String getBy() {
        fireOnPreRead(BY, by);
        String result = this.by;
        fireOnPostRead(BY, by);
        return result;
}

     /**
      * getAggregate :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

     /**
      * getComposite :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

     /**
      * toString :
      * @return String 
      */

    @Override    public String toString() {
        String result = new ToStringBuilder(this).
            append(REPLACE, this.replace).
            append(BY, this.by).
         toString();
        return result;
}


} //TopiaExpressionLinkAbstract
