package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class TopiaAuthorizationDAOAbstract<E extends TopiaAuthorization> extends TopiaDAOImpl<E> implements TopiaDAO<E> {


     /**
      * getEntityClass :
      * @return Class<E> 
      */
    public Class<E> getEntityClass() {
        return (Class<E>)TopiaAuthorization.class;
    }

     /**
      * delete :
      * @param entity 
      * @throws TopiaException
      */
    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

     /**
      * findUsages :
      * @param type 
      * @param entity 
      * @return <U extends TopiaEntity> List<U> 
      * @throws TopiaException
      */

    @Override    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

     /**
      * findAllUsages :
      * @param entity 
      * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
      * @throws TopiaException
      */

    @Override    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //TopiaAuthorizationDAOAbstract<E extends TopiaAuthorization>
