/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.event.TopiaEntitiesVetoable;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorizationImpl;
import org.nuiton.topia.taas.entities.TaasPrincipalImpl;
import org.nuiton.topia.taas.entities.TaasUserImpl;
import org.nuiton.topia.taas.event.TaasAccessEntity;
import org.nuiton.topia.taas.event.TaasEntityVetoable;
import org.nuiton.topia.taas.jaas.TaasConfiguration;
import org.nuiton.topia.taas.jaas.TaasLoginModule;
import org.nuiton.topia.taas.jaas.TaasPermission;
import org.nuiton.topia.taas.jaas.TaasPolicy;
import org.nuiton.topia.taas.jaas.TaasPrincipalWrapper;
import org.nuiton.topia.taas.jaas.TaasSubjectFinder;
import org.nuiton.topia.taas.jaas.TaasSubjectFinderImpl;

public class TaasService
implements TopiaService,
TopiaTransactionVetoable {
    private static Log log = LogFactory.getLog(TaasService.class);
    public static final String SERVICE_NAME = "taas";
    public static final String SERVICE_LOGIN_MODULE = TaasLoginModule.class.getName();
    public static final String SERVICE_EVENT = "topia.service.taas.event";
    public static final String SERVICE_SUBJECT = "topia.service.taas.subject";
    public static final String TOPIA_SERVICE_TAAS = "topia.service.taas";
    private TaasPolicy policy = new TaasPolicy(this);
    private TopiaContextImplementor rootContext;
    private TopiaContext rootContextNoSecure;
    private TaasAccessEntity accessEntity;
    private TaasSubjectFinder subjectFinder;

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{TaasUserImpl.class, TaasPrincipalImpl.class, TaasAuthorizationImpl.class};
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public boolean preInit(TopiaContextImplementor context) {
        this.rootContext = context;
        try {
            Properties config = (Properties)this.rootContext.getConfig().clone();
            String eventString = config.getProperty(SERVICE_EVENT);
            if (eventString != null && !"".equals(eventString)) {
                Class<?> eventClass = Class.forName(eventString);
                Constructor<?> eventConstructor = eventClass.getConstructor(TaasService.class);
                this.accessEntity = (TaasAccessEntity)eventConstructor.newInstance(this);
            } else {
                this.accessEntity = new TaasEntityVetoable(this);
            }
            String subjectString = config.getProperty(SERVICE_SUBJECT);
            if (subjectString != null && !"".equals(subjectString)) {
                Class<?> subjectClass = Class.forName(subjectString);
                this.subjectFinder = (TaasSubjectFinder)subjectClass.newInstance();
            } else {
                this.subjectFinder = new TaasSubjectFinderImpl();
            }
            config.remove(TOPIA_SERVICE_TAAS);
            String persistences = config.getProperty("topia.persistence.classes");
            for (Class<?> klass : this.getPersistenceClasses()) {
                persistences = persistences + "," + klass.getName();
            }
            config.setProperty("topia.persistence.classes", persistences);
            this.rootContextNoSecure = TopiaContextFactory.getContext((Properties)config);
        }
        catch (Exception e) {
            throw new SecurityException("Init security error", e);
        }
        this.initSecurity((TopiaContext)this.rootContext);
        return true;
    }

    public void beginTransaction(TopiaTransactionEvent event) {
        TopiaContext context = event.getSource();
        if (this.subjectFinder != null) {
            this.initSecurity(context);
        }
    }

    private void initSecurity(TopiaContext context) {
        Class<?>[] noLoadClasses;
        List entitiesClasses = this.rootContext.getPersistenceClasses();
        for (Class clazz : entitiesClasses) {
            context.addTopiaEntityVetoable(clazz, (TopiaEntityVetoable)this.accessEntity);
        }
        for (Class<?> clazz : noLoadClasses = this.getPersistenceClasses()) {
            context.addTopiaEntityVetoable(clazz, (TopiaEntityVetoable)this.accessEntity);
        }
        context.addTopiaEntitiesVetoable((TopiaEntitiesVetoable)this.accessEntity);
        context.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.policy.installPolicy();
        if (Configuration.getConfiguration() == null) {
            Configuration.setConfiguration(new TaasConfiguration(SERVICE_NAME, this));
        }
        return true;
    }

    public TopiaContextImplementor getRootContext() {
        return this.rootContext;
    }

    public TopiaContext getRootContextNoSecure() throws TopiaException {
        return this.rootContextNoSecure;
    }

    public Subject findSubject() {
        Subject subject = this.subjectFinder.findSubject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("findSubject : " + this.subjectFinder + " value " + subject));
        }
        return subject;
    }

    public void check(Collection<? extends TopiaEntity> entities, int actions) throws SecurityException {
        Subject subj = this.findSubject();
        if (subj != null) {
            Iterator<? extends TopiaEntity> iterator = entities.iterator();
            while (iterator.hasNext()) {
                TopiaEntity entity = iterator.next();
                try {
                    TaasPermission myp = new TaasPermission(entity.getTopiaId(), actions);
                    this.checkPermission(subj, myp);
                }
                catch (SecurityException se) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(TaasUtil.getPrincipalNames(subj) + " does not have permissions to load: " + entity), (Throwable)se);
                    }
                    iterator.remove();
                }
            }
        } else {
            throw new SecurityException("Use doAs() and login first");
        }
    }

    public void check(TopiaEntity entity, int actions) throws SecurityException {
        this.check(entity.getTopiaId(), actions);
    }

    public void check(String topiaId, int actions) throws SecurityException {
        Subject subj = this.findSubject();
        if (subj != null) {
            try {
                TaasPermission myp = new TaasPermission(topiaId, actions);
                this.checkPermission(subj, myp);
            }
            catch (SecurityException se) {
                throw new SecurityException("Access denied to object \"" + topiaId + "\" for \"" + TaasUtil.getPrincipalNames(subj) + "\"", se);
            }
        } else {
            throw new SecurityException("Use doAs() and login first");
        }
    }

    protected void checkPermission(Subject subj, Permission myp) {
        Set<TaasPrincipalWrapper> ps = subj.getPrincipals(TaasPrincipalWrapper.class);
        for (TaasPrincipalWrapper p : ps) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check permissions for principal wrapper : " + p));
            }
            if (!p.getPermissions().implies(myp)) continue;
            return;
        }
        throw new SecurityException("Access denied to object " + myp);
    }

    public void checkRequestPermission(TopiaEntity entity, int actions) throws SecurityException {
        Subject subj = this.findSubject();
        if (subj != null) {
            List<Permission> permissions = this.getRequestPermission(entity, actions);
            if (permissions == null) {
                try {
                    TaasPermission myp = new TaasPermission(entity.getTopiaId(), actions);
                    this.checkPermission(subj, myp);
                }
                catch (SecurityException se) {
                    throw new SecurityException("Access denied to object \"" + entity.getTopiaId() + "\" for \"" + TaasUtil.getPrincipalNames(subj) + "\"", se);
                }
            } else {
                Iterator<Permission> i$ = permissions.iterator();
                if (i$.hasNext()) {
                    Permission permission = i$.next();
                    try {
                        this.checkPermission(subj, permission);
                    }
                    catch (SecurityException se) {
                        throw new SecurityException("Access denied to object \"" + entity.getTopiaId() + "\" for \"" + TaasUtil.getPrincipalNames(subj) + "\"", se);
                    }
                }
            }
        } else {
            throw new SecurityException("Use doAs() and login first");
        }
    }

    public void checkRequestPermission(Collection<? extends TopiaEntity> entities, int actions) throws SecurityException {
        Subject subj = this.findSubject();
        if (subj != null) {
            Iterator<? extends TopiaEntity> iterator = entities.iterator();
            block4: while (iterator.hasNext()) {
                TopiaEntity entity = iterator.next();
                List<Permission> permissions = this.getRequestPermission(entity, actions);
                if (permissions == null) {
                    try {
                        AccessController.checkPermission(new TaasPermission(entity.getTopiaId(), actions));
                    }
                    catch (SecurityException se) {
                        iterator.remove();
                    }
                    continue;
                }
                for (Permission permission : permissions) {
                    try {
                        AccessController.checkPermission(permission);
                        continue block4;
                    }
                    catch (SecurityException se) {
                        iterator.remove();
                    }
                }
            }
        } else {
            throw new SecurityException("Use doAs() and login first");
        }
    }

    public List<Permission> getRequestPermission(TopiaEntity entity, int actions) {
        List permissions;
        Class klass;
        String topiaId = entity.getTopiaId();
        try {
            klass = TopiaId.getClassName((String)topiaId);
        }
        catch (TopiaNotFoundException e) {
            throw new SecurityException("Invalid topiaId", e);
        }
        try {
            TopiaContextImplementor transaction = (TopiaContextImplementor)((TopiaEntityAbstract)entity).getTopiaContext();
            TopiaDAO dao = transaction.getDAO(klass);
            permissions = dao.getRequestPermission(topiaId, actions);
        }
        catch (TopiaException e) {
            throw new SecurityException("Error in getRequestPermission for " + klass.getName(), e);
        }
        return permissions;
    }
}

