/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.jaas;

import java.security.Permission;
import org.nuiton.topia.taas.entities.TaasAuthorization;

public class TaasPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    public String authorizationExpression;
    public int authorizationActions;

    public TaasPermission(String expression, int actions) {
        super(expression);
        this.authorizationExpression = expression;
        this.authorizationActions = actions;
    }

    public TaasPermission(TaasAuthorization authorization) {
        this(authorization.getExpression(), authorization.getActions());
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (!(permission instanceof TaasPermission)) {
            return false;
        }
        TaasPermission other = (TaasPermission)permission;
        return this.impliesExpression(this.authorizationExpression, other.getAuthorizationExpression()) && this.impliesActions(this.authorizationActions, other.getAuthorizationActions());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaasPermission)) {
            return false;
        }
        TaasPermission that = (TaasPermission)obj;
        return this.implies(that) && that.implies(this);
    }

    @Override
    public int hashCode() {
        return this.authorizationExpression.hashCode() * 100 + this.authorizationActions;
    }

    @Override
    public String getActions() {
        return String.valueOf(this.authorizationActions);
    }

    public int getAuthorizationActions() {
        return this.authorizationActions;
    }

    public String getAuthorizationExpression() {
        return this.authorizationExpression;
    }

    public boolean impliesExpression(String thisExpression, String thatExpression) {
        return thisExpression.equals(thatExpression) || "*".equals(thisExpression) || thatExpression.startsWith(thisExpression.substring(0, thisExpression.length() - 1)) && thisExpression.endsWith("*");
    }

    public boolean impliesActions(int thisActions, int thatActions) {
        boolean result = true;
        if ((thatActions & 1) == 1) {
            result &= (thisActions & 1) == 1;
        }
        if ((thatActions & 2) == 2) {
            result &= (thisActions & 2) == 2;
        }
        if ((thatActions & 4) == 4) {
            result &= (thisActions & 4) == 4;
        }
        if ((thatActions & 8) == 8) {
            result &= (thisActions & 8) == 8;
        }
        return result;
    }
}

