/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class TaasUserAbstract
extends TopiaEntityAbstract
implements TaasUser {
    protected String login;
    protected String password;
    protected String email;
    protected boolean enabled;
    protected Date lastConnectionDate;
    protected int numberOfConnection;
    public String link;
    public Collection<TaasPrincipal> principals;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TaasUser.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TaasUser.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "email", String.class, (Object)this.email);
        visitor.visit((TopiaEntity)this, "enabled", Boolean.TYPE, (Object)this.enabled);
        visitor.visit((TopiaEntity)this, "lastConnectionDate", Date.class, (Object)this.lastConnectionDate);
        visitor.visit((TopiaEntity)this, "numberOfConnection", Integer.TYPE, (Object)this.numberOfConnection);
        visitor.visit((TopiaEntity)this, "link", String.class, (Object)this.link);
        visitor.visit((TopiaEntity)this, "principals", Collection.class, TaasPrincipal.class, this.principals);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> accept() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        this.fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        this.fireOnPostWrite("login", _oldValue, value);
    }

    @Override
    public String getLogin() {
        this.fireOnPreRead("login", this.login);
        String result = this.login;
        this.fireOnPostRead("login", this.login);
        return result;
    }

    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        this.fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        this.fireOnPostWrite("password", _oldValue, value);
    }

    @Override
    public String getPassword() {
        this.fireOnPreRead("password", this.password);
        String result = this.password;
        this.fireOnPostRead("password", this.password);
        return result;
    }

    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        this.fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        this.fireOnPostWrite("email", _oldValue, value);
    }

    @Override
    public String getEmail() {
        this.fireOnPreRead("email", this.email);
        String result = this.email;
        this.fireOnPostRead("email", this.email);
        return result;
    }

    @Override
    public void setEnabled(boolean value) {
        boolean _oldValue = this.enabled;
        this.fireOnPreWrite("enabled", _oldValue, value);
        this.enabled = value;
        this.fireOnPostWrite("enabled", _oldValue, value);
    }

    @Override
    public boolean getEnabled() {
        this.fireOnPreRead("enabled", this.enabled);
        boolean result = this.enabled;
        this.fireOnPostRead("enabled", this.enabled);
        return result;
    }

    @Override
    public void setLastConnectionDate(Date value) {
        Date _oldValue = this.lastConnectionDate;
        this.fireOnPreWrite("lastConnectionDate", _oldValue, value);
        this.lastConnectionDate = value;
        this.fireOnPostWrite("lastConnectionDate", _oldValue, value);
    }

    @Override
    public Date getLastConnectionDate() {
        this.fireOnPreRead("lastConnectionDate", this.lastConnectionDate);
        Date result = this.lastConnectionDate;
        this.fireOnPostRead("lastConnectionDate", this.lastConnectionDate);
        return result;
    }

    @Override
    public void setNumberOfConnection(int value) {
        int _oldValue = this.numberOfConnection;
        this.fireOnPreWrite("numberOfConnection", _oldValue, value);
        this.numberOfConnection = value;
        this.fireOnPostWrite("numberOfConnection", _oldValue, value);
    }

    @Override
    public int getNumberOfConnection() {
        this.fireOnPreRead("numberOfConnection", this.numberOfConnection);
        int result = this.numberOfConnection;
        this.fireOnPostRead("numberOfConnection", this.numberOfConnection);
        return result;
    }

    @Override
    public void setLink(String value) {
        String _oldValue = this.link;
        this.fireOnPreWrite("link", _oldValue, value);
        this.link = value;
        this.fireOnPostWrite("link", _oldValue, value);
    }

    @Override
    public String getLink() {
        this.fireOnPreRead("link", this.link);
        String result = this.link;
        this.fireOnPostRead("link", this.link);
        return result;
    }

    @Override
    public void addPrincipals(TaasPrincipal principals) {
        this.fireOnPreWrite("principals", null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }
        this.principals.add(principals);
        this.fireOnPostWrite("principals", this.principals.size(), null, principals);
    }

    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> values) {
        if (values == null) {
            return;
        }
        for (TaasPrincipal item : values) {
            this.addPrincipals(item);
        }
    }

    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return (TaasPrincipal)TopiaEntityHelper.getEntityByTopiaId(this.principals, (String)topiaId);
    }

    @Override
    public void setPrincipals(Collection<TaasPrincipal> values) {
        Collection<TaasPrincipal> _oldValue = this.principals;
        this.fireOnPreWrite("principals", _oldValue, values);
        this.principals = values;
        this.fireOnPostWrite("principals", _oldValue, values);
    }

    @Override
    public void removePrincipals(TaasPrincipal value) {
        this.fireOnPreWrite("principals", value, null);
        if (this.principals == null || !this.principals.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("principals", this.principals.size() + 1, value, null);
    }

    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        ArrayList<TaasPrincipal> _oldValue = new ArrayList<TaasPrincipal>(this.principals);
        this.fireOnPreWrite("principals", _oldValue, this.principals);
        this.principals.clear();
        this.fireOnPostWrite("principals", _oldValue, this.principals);
    }

    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return this.principals;
    }

    @Override
    public int sizePrincipals() {
        if (this.principals == null) {
            return 0;
        }
        return this.principals.size();
    }

    @Override
    public boolean isPrincipalsEmpty() {
        int size = this.sizePrincipals();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("login", (Object)this.login).append("password", (Object)this.password).append("email", (Object)this.email).append("enabled", this.enabled).append("lastConnectionDate", (Object)this.lastConnectionDate).append("numberOfConnection", this.numberOfConnection).append("link", (Object)this.link).append("principals", this.principals).toString();
        return result;
    }
}

