package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLink;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLinkDAO;
import org.nuiton.topia.security.entities.user.TopiaGroup;
import org.nuiton.topia.security.entities.user.TopiaGroupDAO;
import org.nuiton.topia.security.entities.user.TopiaUser;
import org.nuiton.topia.security.entities.user.TopiaUserDAO;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class TopiaSecurityDAOHelper {

    /**
     * no instance for this helper
     */
    protected TopiaSecurityDAOHelper() {
    }

    public static TopiaAssociationAuthorizationDAO getTopiaAssociationAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAssociationAuthorizationDAO result = (TopiaAssociationAuthorizationDAO) ci.getDAO(TopiaAssociationAuthorization.class);
        return result;
    }

    public static TopiaAuthorizationDAO getTopiaAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAuthorizationDAO result = (TopiaAuthorizationDAO) ci.getDAO(TopiaAuthorization.class);
        return result;
    }

    public static TopiaEntityAuthorizationDAO getTopiaEntityAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaEntityAuthorizationDAO result = (TopiaEntityAuthorizationDAO) ci.getDAO(TopiaEntityAuthorization.class);
        return result;
    }

    public static TopiaExpressionLinkDAO getTopiaExpressionLinkDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaExpressionLinkDAO result = (TopiaExpressionLinkDAO) ci.getDAO(TopiaExpressionLink.class);
        return result;
    }

    public static TopiaGroupDAO getTopiaGroupDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaGroupDAO result = (TopiaGroupDAO) ci.getDAO(TopiaGroup.class);
        return result;
    }

    public static TopiaUserDAO getTopiaUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaUserDAO result = (TopiaUserDAO) ci.getDAO(TopiaUser.class);
        return result;
    }

    public static TaasAuthorizationDAO getTaasAuthorizationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasAuthorizationDAO result = (TaasAuthorizationDAO) ci.getDAO(TaasAuthorization.class);
        return result;
    }

    public static TaasPrincipalDAO getTaasPrincipalDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasPrincipalDAO result = (TaasPrincipalDAO) ci.getDAO(TaasPrincipal.class);
        return result;
    }

    public static TaasUserDAO getTaasUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasUserDAO result = (TaasUserDAO) ci.getDAO(TaasUser.class);
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaSecurityEntityEnum[] getContracts() {
        return TopiaSecurityEntityEnum.values();
    }
 
    /*
     * Enumeration of all types of entities managed by this helper.
     */
    public enum TopiaSecurityEntityEnum implements org.nuiton.topia.persistence.TopiaEntityEnum {

        TopiaAssociationAuthorization(TopiaAssociationAuthorization.class),
        TopiaAuthorization(TopiaAuthorization.class),
        TopiaEntityAuthorization(TopiaEntityAuthorization.class),
        TopiaExpressionLink(TopiaExpressionLink.class),
        TopiaGroup(TopiaGroup.class),
        TopiaUser(TopiaUser.class),
        TaasAuthorization(TaasAuthorization.class),
        TaasPrincipal(TaasPrincipal.class),
        TaasUser(TaasUser.class);

        /** the contract of the entity */
        private Class<? extends TopiaEntity> contract;

        /** the fully qualified name of the implementation of the entity */
        private String implementationFQN;

        /** the implementation class of the entity (will be lazy computed at runtime)*/
        private Class<? extends TopiaEntity> implementation;

        TopiaSecurityEntityEnum(Class<? extends TopiaEntity > contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName()+"Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract() {
            return contract;
        }
       
        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return getContract();
        }
        
        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return getImplementation();
        }

        @Override
        public String getImplementationFQN() {
            return implementationFQN;
        }

        @Override
        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
         }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass) {
            return TopiaSecurityDAOHelper.getContractClass(klass) == contract;
        }
 
        @Override
        @SuppressWarnings({"unchecked"})
        public Class<? extends TopiaEntity> getImplementation() {
            if (implementation == null) {
                try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
            }
            return implementation;
        }

        public static TopiaSecurityEntityEnum valueOf(TopiaEntity entity) {
            return valueOf(entity.getClass());
        }

        public static TopiaSecurityEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return TopiaSecurityEntityEnum.valueOf(klass.getSimpleName());
            }
            for (TopiaSecurityEntityEnum entityEnum : TopiaSecurityEntityEnum.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaSecurityEntityEnum.values()));
        }        
    }

    /**
     * use {@link #getImplementationClassesAsString()}
     *
     * @deprecated (will be removed soon).
     */
    public static final String entitiesList = "" +
        "org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorizationImpl," +
        "org.nuiton.topia.security.entities.authorization.TopiaAuthorizationImpl," +
        "org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationImpl," +
        "org.nuiton.topia.security.entities.authorization.TopiaExpressionLinkImpl," +
        "org.nuiton.topia.security.entities.user.TopiaGroupImpl," +
        "org.nuiton.topia.security.entities.user.TopiaUserImpl," +
        "org.nuiton.topia.taas.entities.TaasAuthorizationImpl," +
        "org.nuiton.topia.taas.entities.TaasPrincipalImpl," +
        "org.nuiton.topia.taas.entities.TaasUserImpl";

} //TopiaSecurityDAOHelper
