package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: QueryMissingOrderException.java 2983 2014-01-18 18:21:51Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-7/topia-persistence/src/main/java/org/nuiton/topia/persistence/QueryMissingOrderException.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;

/**
 * If you get this exception, it means that you asked ToPIA to make an operation that needs a deterministic way to sort
 * the result but you didn't defined such query.
 * <p/>
 * To fix you issue, you may use another API call (maybe user findAny instead of findFirst) or change your query by
 * adding an order by clause. A quick and easy fix would be to just use "order by topiaId".
 *
 * @since 3.0
 */
public class QueryMissingOrderException extends TopiaQueryException {

    private static final long serialVersionUID = 8154110639594660107L;

    protected static final String MESSAGE = "Given query needs an ORDER BY clause since the API call you're using " +
            "needs the results sorting to be deterministic";

    public QueryMissingOrderException(String hql, Map<String, Object> hqlParameters) {
        super(MESSAGE, hql, hqlParameters);
    }

}
