/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNotFoundException;

public class LegacyTopiaIdFactory
implements TopiaIdFactory {
    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + entityClass);
        }
        double random = Math.random();
        while (Double.toString(random).contains("E-")) {
            random = Math.random();
        }
        return entityClass.getName() + this.getSeparator() + System.currentTimeMillis() + '#' + random;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException eee) {
            throw new TopiaNotFoundException("Can't find class for " + topiaId, eee);
        }
    }

    @Override
    public String getSeparator() {
        return "#";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
    }
}

