/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv.out;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ext.RepeatableExport;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.csv.out.ExportModelFactory;
import org.nuiton.topia.persistence.csv.out.PrepareDataForExport;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.MetaFilenameAware;
import org.nuiton.topia.persistence.metadata.Metadatas;
import org.nuiton.topia.persistence.metadata.TableMeta;
import org.nuiton.util.TimeLog;

public class TopiaCsvExports {
    private static final Log log = LogFactory.getLog(TopiaCsvExports.class);
    public static final TimeLog TIME_LOG = new TimeLog(TopiaCsvExports.class);

    protected TopiaCsvExports() {
    }

    public static <T extends TopiaEntityEnum> String exportData(TableMeta<T> tableMeta, ExportModelFactory<T> modelFactory, PrepareDataForExport<T> prepareDataForExport) {
        String result;
        long s1 = TimeLog.getTime();
        Export export = TopiaCsvExports.prepareExport(tableMeta, modelFactory, prepareDataForExport);
        TIME_LOG.log(s1, "exportData::prepareExport");
        long s2 = TimeLog.getTime();
        try {
            result = export.toString(Charsets.UTF_8);
        }
        catch (Exception eee) {
            throw new TopiaException("Can not export datas", eee);
        }
        TIME_LOG.log(s2, "exportData::exportToString");
        return result;
    }

    public static <T extends TopiaEntityEnum> void exportData(TableMeta<T> tableMeta, ExportModelFactory<T> modelFactory, PrepareDataForExport<T> prepareDataForExport, File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Export table " + tableMeta + " to " + file));
        }
        long s1 = TimeLog.getTime();
        Export export = TopiaCsvExports.prepareExport(tableMeta, modelFactory, prepareDataForExport);
        TIME_LOG.log(s1, "exportDatas::prepareExport");
        long s2 = TimeLog.getTime();
        try {
            export.write(file, Charsets.UTF_8);
        }
        catch (Exception eee) {
            throw new TopiaException("Can not export datas", eee);
        }
        TIME_LOG.log(s2, "exportData::exportToFile");
    }

    public static <T extends TopiaEntityEnum> void exportData(AssociationMeta<T> associationMeta, ExportModelFactory<T> modelFactory, PrepareDataForExport<T> prepareDataForExport, File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Export association " + associationMeta + " to " + file));
        }
        long s1 = TimeLog.getTime();
        Export export = TopiaCsvExports.prepareExport(associationMeta, modelFactory, prepareDataForExport);
        TIME_LOG.log(s1, "exportData::prepareExport");
        long s2 = TimeLog.getTime();
        try {
            export.write(file, Charsets.UTF_8);
        }
        catch (Exception eee) {
            throw new TopiaException("Can not export datas", eee);
        }
        TIME_LOG.log(s2, "exportData::exportToFile");
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Export<E> prepareExport(TableMeta<T> tableMeta, ExportModelFactory<T> modelFactory, PrepareDataForExport<T> prepareDataForExport) {
        Iterable datas = prepareDataForExport.prepareData(tableMeta);
        ExportModel model = modelFactory.buildForExport(tableMeta);
        return Export.newExport(model, datas);
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Export<E> prepareExport(AssociationMeta<T> associationMeta, ExportModelFactory<T> modelFactory, PrepareDataForExport<T> prepareDataForExport) {
        Iterable datas = prepareDataForExport.prepareData(associationMeta);
        ExportModel model = modelFactory.buildForExport(associationMeta);
        return Export.newExport(model, datas);
    }

    public static <T extends TopiaEntityEnum> Map<T, EntityExportContext<T>> createReplicateEntityVisitorContexts(ExportModelFactory<T> modelFactory, MetaFilenameAware<T>[] entityMetas, Multimap<T, MetaFilenameAware<T>> associations, File container) {
        Preconditions.checkNotNull(modelFactory);
        Preconditions.checkNotNull(entityMetas);
        Preconditions.checkNotNull(associations);
        Preconditions.checkNotNull((Object)container);
        HashMap contexts = Maps.newHashMap();
        for (MetaFilenameAware<T> entityMeta : entityMetas) {
            TableMeta meta = (TableMeta)entityMeta;
            ExportModel model = modelFactory.buildForExport(meta);
            EntityExportContext exportContext = EntityExportContext.newExportContext(model, meta, container);
            Object source = meta.getSource();
            contexts.put(source, exportContext);
            for (MetaFilenameAware metaFilenameAware : associations.get(source)) {
                AssociationMeta associationMeta = (AssociationMeta)metaFilenameAware;
                ExportModel associationModel = modelFactory.buildForExport(associationMeta);
                exportContext.addAssociationExportContext(associationMeta, associationModel, container);
            }
        }
        return contexts;
    }

    public static <T extends TopiaEntityEnum> Map<T, EntityExportContext<T>> createReplicateEntityVisitorContexts(ExportModelFactory<T> modelFactory, Iterable<TableMeta<T>> entityMetas, Iterable<AssociationMeta<T>> associationMetas, File container) {
        Preconditions.checkNotNull(modelFactory);
        Preconditions.checkNotNull(entityMetas);
        Preconditions.checkNotNull(associationMetas);
        Preconditions.checkNotNull((Object)container);
        Multimap associations = Metadatas.split(associationMetas);
        HashMap contexts = Maps.newHashMap();
        for (TableMeta<T> meta : entityMetas) {
            ExportModel model = modelFactory.buildForExport(meta);
            EntityExportContext<T> exportContext = EntityExportContext.newExportContext(model, meta, container);
            T source = meta.getSource();
            contexts.put(source, exportContext);
            for (AssociationMeta associationMeta : associations.get(source)) {
                ExportModel associationModel = modelFactory.buildForExport(associationMeta);
                exportContext.addAssociationExportContext(associationMeta, associationModel, container);
            }
        }
        return contexts;
    }

    public static class AssociationExportContext<T extends TopiaEntityEnum>
    implements Closeable {
        protected final AssociationMeta<T> meta;
        protected final RepeatableExport export;
        protected final Writer writer;
        protected final File entryFile;

        protected AssociationExportContext(ExportModel<TopiaEntity> model, AssociationMeta<T> meta, File container, List<TopiaEntity> data) {
            Preconditions.checkNotNull(model);
            Preconditions.checkNotNull(meta);
            Preconditions.checkNotNull((Object)container);
            Preconditions.checkNotNull(data);
            this.meta = meta;
            this.export = RepeatableExport.newExport(model, data, (boolean)true);
            this.entryFile = meta.newFile(container);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creates AssociationExportContext::" + meta + " - " + this.entryFile.getName()));
            }
            this.writer = meta.newWriter(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.export.isHeaderWritten()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Export association " + this.meta + " to " + this.entryFile));
                    }
                    this.writer.flush();
                } else {
                    FileUtils.deleteQuietly((File)this.entryFile);
                }
            }
            finally {
                IOUtils.closeQuietly((Writer)this.writer);
            }
        }

        public void write() throws Exception {
            this.export.write(this.writer);
        }
    }

    public static class EntityExportContext<T extends TopiaEntityEnum>
    implements Closeable {
        protected final TableMeta<T> meta;
        protected final RepeatableExport export;
        protected final Writer writer;
        private final List<TopiaEntity> data;
        protected final Collection<AssociationExportContext<T>> associationExportContexts;
        protected final File entryFile;

        public static <T extends TopiaEntityEnum> EntityExportContext<T> newExportContext(ExportModel<TopiaEntity> model, TableMeta<T> meta, File container) {
            return new EntityExportContext<T>(model, meta, container);
        }

        protected EntityExportContext(ExportModel<TopiaEntity> model, TableMeta<T> meta, File container) {
            Preconditions.checkNotNull(model);
            Preconditions.checkNotNull(meta);
            Preconditions.checkNotNull((Object)container);
            this.meta = meta;
            this.data = Lists.newArrayList();
            this.export = RepeatableExport.newExport(model, this.data, (boolean)true);
            this.entryFile = meta.newFile(container);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creates EntityExportContext::" + meta + " - " + this.entryFile.getName()));
            }
            this.writer = meta.newWriter(container);
            this.associationExportContexts = Lists.newArrayList();
        }

        public void addAssociationExportContext(AssociationMeta<T> meta, ExportModel<TopiaEntity> model, File container) {
            this.associationExportContexts.add(new AssociationExportContext<T>(model, meta, container, this.data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.export.isHeaderWritten()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Export table " + this.meta + " to " + this.entryFile));
                    }
                    this.writer.flush();
                } else {
                    FileUtils.deleteQuietly((File)this.entryFile);
                }
            }
            finally {
                IOUtils.closeQuietly((Writer)this.writer);
                for (AssociationExportContext<T> c : this.associationExportContexts) {
                    c.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(TopiaEntity data) throws Exception {
            this.data.add(data);
            try {
                this.export.write(this.writer);
            }
            finally {
                this.data.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeAssociations(TopiaEntity data) throws Exception {
            this.data.add(data);
            try {
                for (AssociationExportContext<T> c : this.associationExportContexts) {
                    AssociationMeta cMeta = c.meta;
                    boolean emptyChild = cMeta.isChildEmpty(data);
                    if (emptyChild) continue;
                    c.write();
                }
            }
            finally {
                this.data.clear();
            }
        }
    }
}

