/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.HibernateProvider;
import org.nuiton.topia.HibernateTopiaJpaSupport;
import org.nuiton.topia.HibernateTopiaReplicationSupport;
import org.nuiton.topia.HibernateTopiaSqlSupport;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHibernateSupport;
import org.nuiton.topia.TopiaJpaSupport;
import org.nuiton.topia.TopiaListenableSupport;
import org.nuiton.topia.TopiaPersistenceContext;
import org.nuiton.topia.TopiaReplicationDestination;
import org.nuiton.topia.TopiaSqlSupport;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.persistence.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

public abstract class AbstractTopiaPersistenceContext
implements TopiaPersistenceContext {
    private static final Log log = LogFactory.getLog(AbstractTopiaPersistenceContext.class);
    protected Map<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>> daoCache = Maps.newConcurrentMap();
    protected HibernateTopiaReplicationSupport hibernateTopiaReplicationSupport;
    protected TopiaListenableSupport listenableSupport;
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaFiresSupport firesSupport;
    protected InternalTopiaHibernateSupport hibernateSupport;
    protected TopiaJpaSupport jpaSupport;
    protected TopiaSqlSupport sqlSupport;
    protected boolean closed = false;

    public AbstractTopiaPersistenceContext(HibernateProvider hibernateProvider, TopiaListenableSupport listenableSupport, TopiaIdFactory topiaIdFactory) {
        this.listenableSupport = listenableSupport;
        this.topiaIdFactory = topiaIdFactory;
        this.firesSupport = new TopiaFiresSupport();
        this.hibernateSupport = new InternalTopiaHibernateSupport(hibernateProvider);
        this.startTransaction();
        this.jpaSupport = new HibernateTopiaJpaSupport(this.hibernateSupport, this.firesSupport);
        this.sqlSupport = new HibernateTopiaSqlSupport(this.hibernateSupport);
    }

    protected void startTransaction() throws TopiaException {
        SessionFactory factory = this.hibernateSupport.getHibernateFactory();
        Session result = factory.openSession();
        this.hibernateSupport.setHibernateSession(result);
        result.setFlushMode(FlushMode.MANUAL);
        try {
            result.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.close();
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close hibernate session", (Throwable)e1);
                }
            }
            String message = String.format("An error occurs while asking a new transaction: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
        this.getFiresSupport().fireOnBeginTransaction(this);
    }

    protected void checkClosed() throws TopiaException {
        if (this.closed) {
            throw new TopiaException("This context is closed, it is not possible to use it anymore");
        }
    }

    protected TopiaFiresSupport getFiresSupport() {
        return this.firesSupport;
    }

    @Override
    public <E extends TopiaEntity> E findByTopiaId(String topiaId) {
        this.checkClosed();
        Class entityClass = this.getTopiaIdFactory().getClassName(topiaId);
        TopiaDAO dao = this.getDao(entityClass);
        Object result = dao.findByTopiaId(topiaId);
        return result;
    }

    @Override
    public void update(TopiaEntity entity) {
        this.checkClosed();
        String topiaId = entity.getTopiaId();
        Class entityClass = this.getTopiaIdFactory().getClassName(topiaId);
        TopiaDAO<TopiaEntity> dao = this.getDao(entityClass);
        dao.update(entity);
    }

    @Override
    public TopiaIdFactory getTopiaIdFactory() {
        return this.topiaIdFactory;
    }

    @Override
    public <E extends TopiaEntity> TopiaDAO<E> getDao(Class<E> entityClass) {
        Preconditions.checkArgument((entityClass != null ? 1 : 0) != 0, (Object)"The method 'getDao' requires a non null 'entityClass' parameter");
        SessionFactory hibernateFactory = this.hibernateSupport.getHibernateFactory();
        if (hibernateFactory.getClassMetadata(entityClass) == null && hibernateFactory.getClassMetadata(entityClass.getName() + "Impl") == null && hibernateFactory.getClassMetadata(entityClass.getName() + "Abstract") == null) {
            String message;
            String format;
            if (log.isInfoEnabled()) {
                format = "List of supported persistence classes: %s";
                message = String.format(format, hibernateFactory.getAllClassMetadata().keySet());
                log.info((Object)message);
            }
            format = "The following entity type %s is not managed by this context, you probably forgot to declare it.";
            message = String.format(format, entityClass.getName());
            throw new TopiaException(message);
        }
        TopiaDAO dao = this.daoCache.get(entityClass);
        if (dao == null) {
            String daoClassName = entityClass.getName() + "TopiaDao";
            try {
                Class<?> daoClass = Class.forName(daoClassName);
                dao = (TopiaDAO)daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                log.fatal((Object)("unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)("unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (InvocationTargetException e) {
                log.fatal((Object)("unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (NoSuchMethodException e) {
                log.fatal((Object)("unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("unable to find DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to find DAO class " + daoClassName, e);
            }
            if (dao instanceof AbstractTopiaDao) {
                AbstractTopiaDao abstractTopiaDao = (AbstractTopiaDao)dao;
                abstractTopiaDao.init(this.hibernateSupport, this.jpaSupport, this.sqlSupport, this.listenableSupport, this.topiaIdFactory, this.firesSupport, this);
            }
            this.daoCache.put(entityClass, dao);
        }
        return dao;
    }

    @Override
    public <E extends TopiaEntity, D extends TopiaDAO<E>> D getDao(Class<E> entityClass, Class<D> daoClass) {
        TopiaDAO<E> dao;
        TopiaDAO<E> result = dao = this.getDao(entityClass);
        return (D)result;
    }

    @Override
    public void commitTransaction() {
        this.checkClosed();
        try {
            Session hibernateSession = this.hibernateSupport.getHibernateSession();
            Transaction tx = hibernateSession.getTransaction();
            hibernateSession.flush();
            tx.commit();
            this.getFiresSupport().fireOnPostCommit(this);
            hibernateSession.beginTransaction();
        }
        catch (Exception eee) {
            String message = String.format("An error occurred during commit operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    @Override
    public void rollbackTransaction() {
        this.checkClosed();
        try {
            Session hibernateSession = this.hibernateSupport.getHibernateSession();
            Transaction tx = hibernateSession.getTransaction();
            hibernateSession.clear();
            tx.rollback();
            hibernateSession.close();
            hibernateSession = this.hibernateSupport.getHibernateFactory().openSession();
            this.hibernateSupport.setHibernateSession(hibernateSession);
            hibernateSession.setFlushMode(FlushMode.MANUAL);
            hibernateSession.beginTransaction();
            this.getFiresSupport().fireOnPostRollback(this);
        }
        catch (HibernateException eee) {
            String message = String.format("An error occurred during rollback operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    @Override
    public void closeContext() {
        this.checkClosed();
        this.closed = true;
        this.hibernateSupport.getHibernateSession().close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected HibernateTopiaReplicationSupport getHibernateTopiaReplicationSupport() {
        if (this.hibernateTopiaReplicationSupport == null) {
            this.hibernateTopiaReplicationSupport = new HibernateTopiaReplicationSupport(this.hibernateSupport);
        }
        return this.hibernateTopiaReplicationSupport;
    }

    @Override
    public void replicate(TopiaEntity entity) {
        this.getHibernateTopiaReplicationSupport().replicate(entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaReplicationDestination topiaReplicationDestination, List<T> entities) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicateEntities(topiaReplicationDestination, entities);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaReplicationDestination topiaReplicationDestination, T entity) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicateEntity(topiaReplicationDestination, entity);
    }

    @Override
    public void replicate(TopiaReplicationDestination topiaReplicationDestination, Object ... entityAndCondition) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicate(topiaReplicationDestination, entityAndCondition);
    }

    protected class InternalTopiaHibernateSupport
    implements TopiaHibernateSupport {
        protected HibernateProvider hibernateProvider;
        protected Session hibernateSession;

        protected InternalTopiaHibernateSupport(HibernateProvider hibernateProvider) {
            this.hibernateProvider = hibernateProvider;
        }

        public void setHibernateSession(Session hibernateSession) {
            this.hibernateSession = hibernateSession;
        }

        @Override
        public Session getHibernateSession() {
            Preconditions.checkState((this.hibernateSession != null ? 1 : 0) != 0, (Object)"Session is not yet initialized");
            return this.hibernateSession;
        }

        @Override
        public SessionFactory getHibernateFactory() {
            return this.hibernateProvider.getSessionFactory();
        }

        @Override
        public Configuration getHibernateConfiguration() {
            return this.hibernateProvider.getHibernateConfiguration();
        }
    }
}

