/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.DefaultTopiaIdFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityIdsMap;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyImpl;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentImpl;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeAbstract;
import org.nuiton.topiatest.EmployeImpl;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneAbstract;
import org.nuiton.topiatest.PersonneImpl;

public class TopiaEntityHelperTest {
    protected static TopiaIdFactory topiaIdFactory = new DefaultTopiaIdFactory();
    protected static TopiaEntityEnum[] contracts;
    protected final Set<Class<? extends TopiaEntity>> contractsClass = new HashSet<Class<? extends TopiaEntity>>();

    public TopiaEntityHelperTest() {
        this.contractsClass.add(Company.class);
        this.contractsClass.add(Employe.class);
        this.contractsClass.add(Department.class);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        contracts = TopiaTestDAOHelper.getContracts();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        contracts = null;
    }

    @Test
    public void testgetContract() {
        Class result = TopiaEntityHelper.getContractClass(null, Company.class);
        Assert.assertNull((Object)result);
        Class expResult = Employe.class;
        this.getContractClass(expResult, EmployeImpl.class);
        this.getContractClass(expResult, EmployeAbstract.class);
        this.getContractClass(expResult, Employe.class);
        expResult = Personne.class;
        this.getContractClass(expResult, PersonneImpl.class);
        this.getContractClass(expResult, PersonneAbstract.class);
        this.getContractClass(expResult, Personne.class);
    }

    @Test
    public void testRetainContracts() {
        HashSet<Class<PersonneImpl>> classes = new HashSet<Class<PersonneImpl>>();
        Set result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertTrue((boolean)result.isEmpty());
        classes.add(PersonneImpl.class);
        result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(Personne.class));
        classes.add(PersonneAbstract.class);
        result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(Personne.class));
        classes.add(Personne.class);
        result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(Personne.class));
        classes.clear();
        classes.add(EmployeImpl.class);
        result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(Employe.class));
        classes.add(PersonneImpl.class);
        result = TopiaEntityHelper.retainContracts((TopiaEntityEnum[])contracts, classes);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(Personne.class));
        Assert.assertTrue((boolean)result.contains(Employe.class));
    }

    @Test
    public void testDetectTypes() throws TopiaException {
        CompanyImpl company = new CompanyImpl();
        EmployeImpl employe = new EmployeImpl();
        DepartmentImpl departmnet = new DepartmentImpl();
        this.detectTypes(new Class[]{Company.class, Employe.class, Department.class}, company, employe, departmnet);
        company.addEmploye(employe);
        this.detectTypes(new Class[]{Company.class, Employe.class}, company);
        company.addDepartment(departmnet);
        departmnet.setCompany(company);
        this.detectTypes(new Class[]{Company.class, Employe.class, Department.class}, company);
        company.removeEmploye(employe);
        company.removeDepartment(departmnet);
        this.detectTypes(new Class[]{Company.class}, company);
    }

    @Test
    public void testDetector() throws Exception {
        CompanyImpl company = new CompanyImpl();
        company.setTopiaId(topiaIdFactory.newTopiaId(Company.class, (TopiaEntity)company));
        EmployeImpl employe = new EmployeImpl();
        employe.setTopiaId(topiaIdFactory.newTopiaId(Employe.class, (TopiaEntity)employe));
        DepartmentImpl department = new DepartmentImpl();
        department.setTopiaId(topiaIdFactory.newTopiaId(Department.class, (TopiaEntity)department));
        this.detectEntities(new Class[]{Company.class, Employe.class, Department.class}, new int[]{1, 1, 1}, company, employe, department);
        this.detectEntityIds(new Class[]{Company.class, Employe.class, Department.class}, new int[]{1, 1, 1}, company, employe, department);
        company.addEmploye(employe);
        this.detectEntities(new Class[]{Company.class, Employe.class}, new int[]{1, 1, 1}, company);
        this.detectEntityIds(new Class[]{Company.class, Employe.class}, new int[]{1, 1, 1}, company);
        company.addDepartment(department);
        department.setCompany(company);
        this.detectEntities(new Class[]{Company.class, Employe.class, Department.class}, new int[]{1, 1, 1}, company);
        this.detectEntityIds(new Class[]{Company.class, Employe.class, Department.class}, new int[]{1, 1, 1}, company);
        company.removeEmploye(employe);
        company.removeDepartment(department);
        this.detectEntities(new Class[]{Company.class}, new int[]{1}, company);
        this.detectEntityIds(new Class[]{Company.class}, new int[]{1}, company);
        this.detectEntities(new Class[]{Company.class}, new int[]{2}, company, new CompanyImpl());
        this.detectEntityIds(new Class[]{Company.class}, new int[]{2}, company, new CompanyImpl());
        department.setCompany(company);
        this.detectEntities(new Class[]{Company.class, Department.class}, new int[]{1, 1}, department);
        this.detectEntityIds(new Class[]{Company.class, Department.class}, new int[]{1, 1}, department);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectEntities(Class<?>[] expected, int[] sizes, TopiaEntity ... data) throws TopiaException {
        Map actual = null;
        try {
            actual = TopiaEntityHelper.detectEntities((TopiaEntityEnum[])contracts, this.contractsClass, (TopiaEntity[])data);
            Assert.assertEquals((long)expected.length, (long)actual.size());
            int index = 0;
            for (Class<?> c : expected) {
                List value = (List)actual.get(c);
                int expectedSize = sizes[index++];
                Assert.assertEquals((long)expectedSize, (long)value.size());
            }
        }
        finally {
            if (actual != null) {
                actual.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectEntityIds(Class<?>[] expected, int[] sizes, TopiaEntity ... data) throws TopiaException {
        TopiaEntityIdsMap actual = null;
        try {
            actual = TopiaEntityHelper.detectEntityIds((TopiaEntityEnum[])contracts, this.contractsClass, (TopiaEntity[])data);
            Assert.assertEquals((long)expected.length, (long)actual.size());
            int index = 0;
            for (Class<?> c : expected) {
                List value = (List)actual.get(c);
                int expectedSize = sizes[index++];
                Assert.assertEquals((long)expectedSize, (long)value.size());
            }
        }
        finally {
            if (actual != null) {
                actual.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectTypes(Class<?>[] expected, TopiaEntity ... data) throws TopiaException {
        HashSet<String> fqns = new HashSet<String>(expected.length);
        Set actual = null;
        for (Class<?> c : expected) {
            fqns.add(c.getName());
        }
        try {
            actual = TopiaEntityHelper.detectTypes((TopiaEntityEnum[])contracts, (TopiaEntity[])data);
            Assert.assertEquals((long)expected.length, (long)actual.size());
            for (Class c : actual) {
                Assert.assertTrue((boolean)fqns.contains(c.getName()));
            }
        }
        finally {
            fqns.clear();
            if (actual != null) {
                actual.clear();
            }
        }
    }

    protected void getContractClass(Class<?> expected, Class<? extends TopiaEntity> klass) {
        Class result = TopiaEntityHelper.getContractClass((TopiaEntityEnum[])contracts, klass);
        Assert.assertEquals(expected, (Object)result);
    }
}

