/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentTopiaDao;

public class TopiaTestCase {
    private static final Log log = LogFactory.getLog(TopiaTestCase.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testCompositeAssociations() throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Junit Test testCompositeAssociations");
        }
        TopiaTestTopiaPersistenceContext newContext = this.db.beginTransaction();
        CompanyDAO companyDAO = newContext.getCompanyDao();
        DepartmentTopiaDao departmentDAO = newContext.getDepartmentDao();
        Company company = (Company)companyDAO.create();
        company.setName("Ma soci\u00e9t\u00e9");
        Department dep1 = (Department)departmentDAO.create();
        dep1.setName("Departement 1");
        Department dep2 = (Department)departmentDAO.create();
        dep2.setName("Departement 2");
        Department dep3 = (Department)departmentDAO.create();
        dep3.setName("Departement 3");
        Department dep4 = (Department)departmentDAO.create();
        dep4.setName("Departement 7");
        departmentDAO.update(dep1);
        departmentDAO.update(dep2);
        departmentDAO.update(dep3);
        departmentDAO.update(dep4);
        company.addDepartment(dep1);
        company.addDepartment(dep2);
        company.addDepartment(dep3);
        company.addDepartment(dep4);
        companyDAO.update(company);
        newContext.commitTransaction();
        newContext = this.db.beginTransaction();
        companyDAO = TopiaTestDAOHelper.getCompanyDAO((TopiaDaoSupplier)newContext);
        company = (Company)companyDAO.findByTopiaId(company.getTopiaId());
        Assert.assertEquals((Object)company.getName(), (Object)"Ma soci\u00e9t\u00e9");
        Assert.assertEquals((long)company.getDepartment().size(), (long)4L);
        newContext.commitTransaction();
    }
}

