package org.nuiton.topia;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaJpaSupport.java 2787 2013-08-03 01:14:27Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-3/topia-persistence/src/main/java/org/nuiton/topia/TopiaJpaSupport.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.List;

/**
 * This API provides methods to use persistence using JPA queries
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @since 3.0
 */
// TODO AThimel 02/08/13 I think we need another name
public interface TopiaJpaSupport {

    /**
     * Allow to do some JPA-QL query
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param jpaql                  the JPA-QL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     */
    <T> List<T> findAll(String jpaql,
                        Object... propertyNamesAndValues);

    /**
     * Allow to do some JPA-QL query using the given bounds.
     * <p/>
     * No lower bound : <code>startIndex</code> = 0.<br/>
     * No upper bound : <code>endIndex</code> = -1.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param jpaql                  the JPA-QL query
     * @param startIndex             first index of entity to return
     * @param endIndex               last index of entity to return
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     */
    <T> List<T> find(String jpaql,
                     int startIndex,
                     int endIndex,
                     Object... propertyNamesAndValues);

    /**
     * Allow to do some JPA-QL query and return an unique result. If nothing if
     * found by the query, will return null. If more than one result is found,
     * will throw an exception.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param jpaql                  the JPA-QL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result instance or null
     */
    // TODO AThimel 02/08/13 Throw another exception if more than 1 result is found
    <T> T findUnique(String jpaql,
                     Object... propertyNamesAndValues);

    /**
     * Execute JPA-QL operation on data (Update, Delete).
     *
     * @param jpaql                  the JPA-QL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The number of entities updated or deleted.
     */
    int execute(String jpaql,
                Object... propertyNamesAndValues);

}
