package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.Company;

public abstract class Contact2DAOAbstract<E extends Contact2> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Contact2.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Contact2;
    }

    public abstract Set<Contact2> findAllByCompany(Company company) throws TopiaException;

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<Party2> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from party2 main, contacts_party2 secondary " +
                    "where main.topiaid=secondary.party2" +
                    " and secondary.contacts='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaTestDAOHelper.getImplementationClass(Party2.class)).list();

            for (Party2 item : list) {
                item.removeContacts(entity);
            }
        }

        super.delete(entity);
    }

    public E findByContactValue(String v) throws TopiaException {
        E result = findByProperty(Contact2.PROPERTY_CONTACT_VALUE, v);
        return result;
    }

    public List<E> findAllByContactValue(String v) throws TopiaException {
        List<E> result = findAllByProperty(Contact2.PROPERTY_CONTACT_VALUE, v);
        return result;
    }

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(Contact2.PROPERTY_TYPE, v);
        return result;
    }

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Contact2.PROPERTY_TYPE, v);
        return result;
    }

    public E findContainsParty2(Party2 v) throws TopiaException {
        E result = findContains(Contact2.PROPERTY_PARTY2, v);
        return result;
    }

    public List<E> findAllContainsParty2(Party2 v) throws TopiaException {
        List<E> result = findAllContains(Contact2.PROPERTY_PARTY2, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Party2.class) {
            Party2DAO dao = (Party2DAO)
                getContext().getDAO(Party2.class);
            tmp = dao.findAllContainsContacts(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Party2.class, entity);
        if (!list.isEmpty()) {
            result.put(Party2.class, list);
        }

        return result;
    }

} //Contact2DAOAbstract<E extends Contact2>
