package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class AddressDAOAbstract<E extends Address> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Address.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Personne> list = getContext()
                                                    .getDAO(Personne.class)
                                                    .findAllByProperties(Personne.PROPERTY_ADDRESS, entity);
                                            for (Personne item : list) {
                                                item.setAddress(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByCity :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut city le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCity(String v) throws TopiaException {
        E result = findByProperty(Address.PROPERTY_CITY, v);
        return result;
    }

    /**
     * findAllByCity :
     * Retourne les éléments ayant comme valeur pour l'attribut city le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCity(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.PROPERTY_CITY, v);
        return result;
    }

    /**
     * findByAdress :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut adress le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAdress(String v) throws TopiaException {
        E result = findByProperty(Address.PROPERTY_ADRESS, v);
        return result;
    }

    /**
     * findAllByAdress :
     * Retourne les éléments ayant comme valeur pour l'attribut adress le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAdress(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.PROPERTY_ADRESS, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Personne.class) {
            PersonneDAO dao = (PersonneDAO)
                getContext().getDAO(Personne.class);
            tmp = dao.findAllByAddress(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Personne.class, entity);
        if (!list.isEmpty()) {
            result.put(Personne.class, list);
        }

        return result;
    }


} //AddressDAOAbstract<E extends Address>
