/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.util.FileUtil;

@Ignore
public class TestHelper {
    private static final Log log = LogFactory.getLog(TestHelper.class);
    protected static File testBasedir;
    protected static File targetdir;
    protected static File dirDatabase;
    public static final String DEFAULT_CONFIGURATION_LOCATION = "/TopiaContextImpl.properties";

    public static File getTestWorkdir() {
        if (testBasedir == null) {
            String base = System.getProperty("java.io.tmpdir");
            if (base == null || base.isEmpty()) {
                base = new File("").getAbsolutePath();
            }
            testBasedir = new File(base);
            log.info((Object)("basedir for test " + testBasedir));
        }
        return testBasedir;
    }

    public static File getTestBasedir(Class<?> testClass) throws IOException {
        File dir = TestHelper.getTestWorkdir();
        File result = new File(dir, testClass.getName());
        if (result.exists()) {
            FileUtil.deleteRecursively((File)result);
        }
        FileUtil.createDirectoryIfNecessary((File)result);
        return result;
    }

    public static TopiaContext initTopiaContext(File testDirectory, String dbname) throws IOException, TopiaNotFoundException {
        TopiaContext topiaContext = TestHelper.initTopiaContext(testDirectory, DEFAULT_CONFIGURATION_LOCATION, dbname);
        return topiaContext;
    }

    public static TopiaContext initTopiaContext(File testDirectory, String dbPropertiesPath, String dbname) throws IOException, TopiaNotFoundException {
        Properties configuration = TestHelper.initTopiaContextConfiguration(testDirectory, dbPropertiesPath, dbname);
        return TopiaContextFactory.getContext((Properties)configuration);
    }

    public static Properties initTopiaContextConfiguration(File testDirectory, String dbPropertiesPath, String dbname) throws IOException {
        Properties configuration = TestHelper.loadHibernateConfiguration(dbPropertiesPath);
        String dbPath = TestHelper.getDbName(testDirectory, dbname);
        if (log.isInfoEnabled()) {
            log.info((Object)("dbPath = " + dbPath));
        }
        configuration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath);
        return configuration;
    }

    public static Properties loadHibernateConfiguration(String dbPropertiesPath) throws IOException {
        InputStream stream = TestHelper.class.getResourceAsStream(dbPropertiesPath);
        Properties configuration = new Properties();
        configuration.load(stream);
        configuration.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
        return configuration;
    }

    public static String getDbName(File testDirectory, String dbname) {
        return new File(testDirectory, dbname + '_' + System.nanoTime()).getAbsolutePath();
    }

    public static Properties initTopiaContextConfiguration(File testDirectory, String dbname) throws IOException {
        return TestHelper.initTopiaContextConfiguration(testDirectory, DEFAULT_CONFIGURATION_LOCATION, dbname);
    }
}

