package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetDAO;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceDAO;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.BillDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;
import org.nuiton.topiatest.ExtraDAOEntity;
import org.nuiton.topiatest.ExtraDAOEntityDAO;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.ProductDAO;
import org.nuiton.topiatest.QueriedEntity;
import org.nuiton.topiatest.QueriedEntityDAO;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.StoreDAO;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.TypeDAO;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Contact2DAO;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Party2DAO;
import org.nuiton.topiatest.deletetest.Telephone2;
import org.nuiton.topiatest.deletetest.Telephone2DAO;

public class TopiaTestDAOHelper {

    public enum TopiaTestEntityEnum implements TopiaEntityEnum {
        Person(Person.class),
        Pet(Pet.class),
        Race(Race.class),
        Address(Address.class),
        Bill(Bill.class),
        Company(Company.class),
        Department(Department.class),
        Employe(Employe.class),
        ExtraDAOEntity(ExtraDAOEntity.class),
        NaturalizedEntity(NaturalizedEntity.class, "naturalIdNotNull", "naturalIdNull"),
        Personne(Personne.class),
        Product(Product.class),
        QueriedEntity(QueriedEntity.class),
        Store(Store.class),
        Type(Type.class),
        Contact2(Contact2.class),
        Party2(Party2.class),
        Telephone2(Telephone2.class);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        TopiaTestEntityEnum(Class<? extends TopiaEntity > contract, String... naturalIds)     {
        this.contract = contract;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        implementation = null;
        // reinit the operators store
        EntityOperatorStore.clear();
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return TopiaTestDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static TopiaTestEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static TopiaTestEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (TopiaTestEntityEnum entityEnum : TopiaTestEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaTestEntityEnum.values()));
        }

    } //TopiaTestEntityEnum

    protected TopiaTestDAOHelper() { }

    public static String getModelVersion() {
        return "1.2";
    }

    public static String getModelName() {
        return "TopiaTest";
    }

    public static PersonDAO getPersonDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonDAO result = ci.getDAO(Person.class, PersonDAO.class);
        return result;
    }

    public static PetDAO getPetDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PetDAO result = ci.getDAO(Pet.class, PetDAO.class);
        return result;
    }

    public static RaceDAO getRaceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        RaceDAO result = ci.getDAO(Race.class, RaceDAO.class);
        return result;
    }

    public static AddressDAO getAddressDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AddressDAO result = ci.getDAO(Address.class, AddressDAO.class);
        return result;
    }

    public static BillDAO getBillDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        BillDAO result = ci.getDAO(Bill.class, BillDAO.class);
        return result;
    }

    public static CompanyDAO getCompanyDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CompanyDAO result = ci.getDAO(Company.class, CompanyDAO.class);
        return result;
    }

    public static DepartmentDAO getDepartmentDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        DepartmentDAO result = ci.getDAO(Department.class, DepartmentDAO.class);
        return result;
    }

    public static EmployeDAO getEmployeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EmployeDAO result = ci.getDAO(Employe.class, EmployeDAO.class);
        return result;
    }

    public static ExtraDAOEntityDAO getExtraDAOEntityDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ExtraDAOEntityDAO result = ci.getDAO(ExtraDAOEntity.class, ExtraDAOEntityDAO.class);
        return result;
    }

    public static NaturalizedEntityDAO getNaturalizedEntityDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        NaturalizedEntityDAO result = ci.getDAO(NaturalizedEntity.class, NaturalizedEntityDAO.class);
        return result;
    }

    public static PersonneDAO getPersonneDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonneDAO result = ci.getDAO(Personne.class, PersonneDAO.class);
        return result;
    }

    public static ProductDAO getProductDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductDAO result = ci.getDAO(Product.class, ProductDAO.class);
        return result;
    }

    public static QueriedEntityDAO getQueriedEntityDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        QueriedEntityDAO result = ci.getDAO(QueriedEntity.class, QueriedEntityDAO.class);
        return result;
    }

    public static StoreDAO getStoreDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        StoreDAO result = ci.getDAO(Store.class, StoreDAO.class);
        return result;
    }

    public static TypeDAO getTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TypeDAO result = ci.getDAO(Type.class, TypeDAO.class);
        return result;
    }

    public static Contact2DAO getContact2DAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Contact2DAO result = ci.getDAO(Contact2.class, Contact2DAO.class);
        return result;
    }

    public static Party2DAO getParty2DAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Party2DAO result = ci.getDAO(Party2.class, Party2DAO.class);
        return result;
    }

    public static Telephone2DAO getTelephone2DAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        Telephone2DAO result = ci.getDAO(Telephone2.class, Telephone2DAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaTestEntityEnum[] getContracts() {
        return TopiaTestEntityEnum.values();
    }

    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return EntityOperatorStore.getOperator(constant);
    }

} //TopiaTestDAOHelper
