/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaDAOTest.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.2/topia-persistence/src/test/java/org/nuiton/topia/persistence/TopiaDAOTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.framework.TopiaUtilTest;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Test on {@link TopiaDAO}.
 *
 * @author chatellier
 * @version $Revision: 2245 $
 *          <p/>
 *          Last update : $Date: 2011-04-14 14:47:09 +0200 (Thu, 14 Apr 2011) $
 *          By : $Author: tchemit $
 */
public class TopiaDAOTest {

    private static final Log log = LogFactory.getLog(TopiaUtilTest.class);

    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {

        testBasedir = TestHelper.getTestBasedir(TopiaDAOTest.class);
    }

    /**
     * Test de creer une entité et de verifier qu'elle est
     * présente dans la persistence au sein de la transaction.
     *
     * @throws TopiaException
     * @throws IOException
     */
    @Test
    public void testCreateAndFindInTransaction() throws TopiaException, IOException {

        TopiaContext rootContext = TestHelper.initTopiaContext(
                testBasedir,
                "/TopiaContextImpl.properties",
                "testCreateAndFindInTransaction"
        );

        TopiaContext context = rootContext.beginTransaction();

        PersonDAO personDAO = TopiaTestDAOHelper.getPersonDAO(context);

        // appel 1 find all
        Person person = personDAO.create();
        person.setName("toto");
        List<Person> allPerson = personDAO.findAll();
        Assert.assertEquals(1, allPerson.size());
        context.commitTransaction();

        // recherce la personne créée dans la même transaction
        Person person2 = personDAO.create();
        person2.setName("titi");
        allPerson = personDAO.findAll();
        Assert.assertEquals(2, allPerson.size());
        Assert.assertThat(allPerson, JUnitMatchers.hasItem(person2));

        context.rollbackTransaction();

        // meme test apres roolback
        Person person3 = personDAO.create();
        person3.setName("tata");
        allPerson = personDAO.findAll();
        Assert.assertEquals(2, allPerson.size());
        Assert.assertThat(allPerson, JUnitMatchers.hasItem(person3));

        context.commitTransaction();
        rootContext.closeContext();
    }
}
