/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DepartmentDTO implements Serializable {

    protected String topiaId;

    public String name;

    public EmployeDTO leader;

    public CompanyDTO company;

    public ProductDTO[] product;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    public String getName() {
        return name;
    }

    public void setLeader(EmployeDTO value) {
        org.nuiton.topiatest.EmployeDTO oldValue = this.leader;
        this.leader = value;
        p.firePropertyChange("leader", oldValue, value);
    }

    public EmployeDTO getLeader() {
        return leader;
    }

    public void setCompany(CompanyDTO value) {
        org.nuiton.topiatest.CompanyDTO oldValue = this.company;
        this.company = value;
        p.firePropertyChange("company", oldValue, value);
    }

    public CompanyDTO getCompany() {
        return company;
    }

    public void setProduct(ProductDTO[] values) {
        org.nuiton.topiatest.ProductDTO[] oldValues = this.product;
        this.product = values;
        p.firePropertyChange("product", oldValues, values);
    }

    public ProductDTO[] getProduct() {
        return product;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("leader", this.leader).
            append("product", this.product).
         toString();
        return result;
}

} //DepartmentDTO
