/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CompanyDTO implements Serializable {

    protected String topiaId;

    public String name;

    public int siret;

    public EmployeDTO[] employe;

    public BillDTO[] storeBill;

    public DepartmentDTO[] department;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    public String getName() {
        return name;
    }

    public void setSiret(int value) {
        int oldValue = this.siret;
        this.siret = value;
        p.firePropertyChange("siret", oldValue, value);
    }

    public int getSiret() {
        return siret;
    }

    public void setEmploye(EmployeDTO[] values) {
        org.nuiton.topiatest.EmployeDTO[] oldValues = this.employe;
        this.employe = values;
        p.firePropertyChange("employe", oldValues, values);
    }

    public EmployeDTO[] getEmploye() {
        return employe;
    }

    public void setStoreBill(BillDTO[] values) {
        org.nuiton.topiatest.BillDTO[] oldValues = this.storeBill;
        this.storeBill = values;
        p.firePropertyChange("store", oldValues, values);
    }

    public BillDTO[] getStoreBill() {
        return this.storeBill;
    }

    public void setDepartment(DepartmentDTO[] values) {
        org.nuiton.topiatest.DepartmentDTO[] oldValues = this.department;
        this.department = values;
        p.firePropertyChange("department", oldValues, values);
    }

    public DepartmentDTO[] getDepartment() {
        return department;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("siret", this.siret).
            append("employe", this.employe).
         toString();
        return result;
}

} //CompanyDTO
