package org.nuiton.topia.test.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public  class PetDTO implements Serializable {

    public String name;
    public String type;
    public PersonDTO person;
    public RaceDTO race;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return name;
    }

    /**
     * setType :
     * @param value 
     */

    public void setType(String value) {
        java.lang.String oldValue = this.type;
        this.type = value;
        p.firePropertyChange("type", oldValue, value);
    }

    /**
     * getType :
     * @return String 
     */

    public String getType() {
        return type;
    }

    /**
     * setPerson :
     * @param value 
     */

    public void setPerson(PersonDTO value) {
        org.nuiton.topia.test.entities.PersonDTO oldValue = this.person;
        this.person = value;
        p.firePropertyChange("person", oldValue, value);
    }

    /**
     * getPerson :
     * @return PersonDTO 
     */

    public PersonDTO getPerson() {
        return person;
    }

    /**
     * setRace :
     * @param value 
     */

    public void setRace(RaceDTO value) {
        org.nuiton.topia.test.entities.RaceDTO oldValue = this.race;
        this.race = value;
        p.firePropertyChange("race", oldValue, value);
    }

    /**
     * getRace :
     * @return RaceDTO 
     */

    public RaceDTO getRace() {
        return race;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("type", this.type).
            append("race", this.race).
         toString();
        return result;
}


} //PetDTO
