package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class EmployeDAOAbstract<E extends Employe> extends PersonneDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Employe.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Department> list = getContext()
                                                    .getDAO(Department.class)
                                                    .findAllByProperties(Department.PROPERTY_LEADER, entity);
                                            for (Department item : list) {
                                                item.setLeader(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findBySalary :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut salary le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySalary(int v) throws TopiaException {
        E result = findByProperty(Employe.PROPERTY_SALARY, v);
        return result;
    }

    /**
     * findAllBySalary :
     * Retourne les éléments ayant comme valeur pour l'attribut salary le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySalary(int v) throws TopiaException {
        List<E> result = findAllByProperty(Employe.PROPERTY_SALARY, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Department.class) {
            DepartmentDAO dao = (DepartmentDAO)
                getContext().getDAO(Department.class);
            tmp = dao.findAllByProperties(Department.PROPERTY_LEADER, entity);
            result.addAll(tmp);
        }

        if (type == Company.class) {
            CompanyDAO dao = (CompanyDAO)
                getContext().getDAO(Company.class);
            tmp = dao.findAllByProperties(Company.PROPERTY_EMPLOYE, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        list = findUsages(Company.class, entity);
        if (!list.isEmpty()) {
            result.put(Company.class, list);
        }

        return result;
    }


} //EmployeDAOAbstract<E extends Employe>
