package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class CompanyDAOAbstract<E extends Company> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Company.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Department> list = getContext()
                                                    .getDAO(Department.class)
                                                    .findAllByProperties(Department.PROPERTY_COMPANY, entity);
                        //                            .findAllByProperties("company", entity);
                                            for (Department item : list) {
                                                item.setCompany(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Company.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Company.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findBySiret :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut siret le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySiret(int v) throws TopiaException {
        E result = findByProperty(Company.PROPERTY_SIRET, v);
        return result;
    }

    /**
     * findAllBySiret :
     * Retourne les éléments ayant comme valeur pour l'attribut siret le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySiret(int v) throws TopiaException {
        List<E> result = findAllByProperty(Company.PROPERTY_SIRET, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Department.class) {
            DepartmentDAO dao = (DepartmentDAO)
                getContext().getDAO(Department.class);
            tmp = dao.findAllByProperties(Department.PROPERTY_COMPANY, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        return result;
    }


} //CompanyDAOAbstract<E extends Company>
