package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class Telephone2DAOAbstract<E extends Telephone2> extends Contact2DAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Telephone2.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByPrefix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut prefix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrefix(String v) throws TopiaException {
        E result = findByProperty(Telephone2.PREFIX, v);
        return result;
    }

    /**
     * findAllByPrefix :
     * Retourne les éléments ayant comme valeur pour l'attribut prefix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrefix(String v) throws TopiaException {
        List<E> result = findAllByProperty(Telephone2.PREFIX, v);
        return result;
    }

    /**
     * findByCountry :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut country le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCountry(String v) throws TopiaException {
        E result = findByProperty(Telephone2.COUNTRY, v);
        return result;
    }

    /**
     * findAllByCountry :
     * Retourne les éléments ayant comme valeur pour l'attribut country le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCountry(String v) throws TopiaException {
        List<E> result = findAllByProperty(Telephone2.COUNTRY, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //Telephone2DAOAbstract<E extends Telephone2>
