package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class BillDAOAbstract<E extends Bill> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Bill.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCost(int v) throws TopiaException {
        E result = findByProperty(Bill.COST, v);
        return result;
    }

    /**
     * findAllByCost :
     * Retourne les éléments ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCost(int v) throws TopiaException {
        List<E> result = findAllByProperty(Bill.COST, v);
        return result;
    }

    /**
     * findByDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut date le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty(Bill.DATE, v);
        return result;
    }

    /**
     * findAllByDate :
     * Retourne les éléments ayant comme valeur pour l'attribut date le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Bill.DATE, v);
        return result;
    }

    /**
     * findContainsStore :
     * Retourne le premier élément trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStore(Store... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Bill.STORE, Arrays.asList(v));
        E result = findContainsProperties("store", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStore :
     * Retourne les éléments trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStore(Store... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Bill.STORE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("store", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsCompany :
     * Retourne le premier élément trouvé dont l'attribut company contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsCompany(Company... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Bill.COMPANY, Arrays.asList(v));
        E result = findContainsProperties("company", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsCompany :
     * Retourne les éléments trouvé dont l'attribut company contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsCompany(Company... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Bill.COMPANY, Arrays.asList(v));
        List<E> results = findAllContainsProperties("company", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //BillDAOAbstract<E extends Bill>
