/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaEntityBinderTest.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/test/java/org/nuiton/topia/persistence/util/TopiaEntityBinderTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topiatest.Company;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;
import org.nuiton.util.beans.BinderProvider;

public class TopiaEntityBinderTest {

    static TopiaEntityEnum[] contracts;

    @BeforeClass
    public static void setUpClass() throws Exception {
        contracts = TopiaTestDAOHelper.getContracts();
    }

    public static class CompanyDTO {
        protected String name;
        protected int siret;
        protected String id;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSiret() {
            return siret;
        }

        public void setSiret(int siret) {
            this.siret = siret;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    @Before
    public void setUp() {
        BinderProvider.clear();
    }

    @Test
    public void testBinder() {

        BinderBuilder builder = new BinderBuilder();
        builder.createBinderModel(Company.class, CompanyDTO.class);
        builder.addSimpleProperties(Company.NAME, Company.SIRET);
        builder.addProperties(TopiaEntity.TOPIA_ID, "id");
        BinderProvider.registerBinder(builder);

        Binder<Company, CompanyDTO> binder =
                BinderProvider.getBinder(Company.class, CompanyDTO.class);
        Assert.assertNotNull(binder);
    }
}
