package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public class DepartmentDTO implements Serializable {

    public String name;
    public EmployeDTO leader;
    public CompanyDTO company;
    public ProductDTO[] product;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return name;
    }

    /**
     * setLeader :
     * @param value 
     */

    public void setLeader(EmployeDTO value) {
        org.nuiton.topiatest.EmployeDTO oldValue = this.leader;
        this.leader = value;
        p.firePropertyChange("leader", oldValue, value);
    }

    /**
     * getLeader :
     * @return EmployeDTO 
     */

    public EmployeDTO getLeader() {
        return leader;
    }

    /**
     * setCompany :
     * @param value 
     */

    public void setCompany(CompanyDTO value) {
        org.nuiton.topiatest.CompanyDTO oldValue = this.company;
        this.company = value;
        p.firePropertyChange("company", oldValue, value);
    }

    /**
     * getCompany :
     * @return CompanyDTO 
     */

    public CompanyDTO getCompany() {
        return company;
    }

    /**
     * setProduct :
     * @param values 
     */

    public void setProduct(ProductDTO[] values) {
        org.nuiton.topiatest.ProductDTO[] oldValues = this.product;
        this.product = values;
        p.firePropertyChange("product", oldValues, values);
    }

    /**
     * getProduct :
     * @return ProductDTO[] 
     */

    public ProductDTO[] getProduct() {
        return product;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("leader", this.leader).
            append("product", this.product).
         toString();
        return result;
}


} //DepartmentDTO
