package org.nuiton.topia.test.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class PersonDAOAbstract<E extends Person> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Person.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<org.nuiton.topia.test.entities.Pet> list = getContext()
                            .getDAO(org.nuiton.topia.test.entities.Pet.class)
                            .findAllByProperties("person", entity);
                    for (org.nuiton.topia.test.entities.Pet item : list) {
                        item.setPerson(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Person.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.NAME, v);
        return result;
    }

    /**
     * findByFirstname :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut firstname le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFirstname(String v) throws TopiaException {
        E result = findByProperty(Person.FIRSTNAME, v);
        return result;
    }

    /**
     * findAllByFirstname :
     * Retourne les éléments ayant comme valeur pour l'attribut firstname le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFirstname(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.FIRSTNAME, v);
        return result;
    }

    /**
     * findContainsPet :
     * Retourne le premier élément trouvé dont l'attribut pet contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPet(Pet... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Person.PET, Arrays.asList(v));
        E result = findContainsProperties("pet", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPet :
     * Retourne les éléments trouvé dont l'attribut pet contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPet(Pet... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Person.PET, Arrays.asList(v));
        List<E> results = findAllContainsProperties("pet", Arrays.asList(v));
        return results;
    }


} //PersonDAOAbstract<E extends Person>
